/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonar.api.server.ServerSide;
import org.sonar.server.util.TypeValidation;
import org.sonar.server.ws.WsUtils;

@ServerSide
public class TypeValidations {
    private final List<TypeValidation> typeValidationList;

    public TypeValidations(List<TypeValidation> typeValidationList) {
        this.typeValidationList = typeValidationList;
    }

    public void validate(List<String> values, String type, List<String> options) {
        TypeValidation typeValidation = this.findByKey(type);
        for (String value : values) {
            typeValidation.validate(value, options);
        }
    }

    public void validate(String value, String type, @Nullable List<String> options) {
        TypeValidation typeValidation = this.findByKey(type);
        typeValidation.validate(value, options);
    }

    private TypeValidation findByKey(String key) {
        TypeValidation typeValidation = (TypeValidation)Iterables.find(this.typeValidationList, (Predicate)new TypeValidationMatchKey(key), null);
        WsUtils.checkRequest(typeValidation != null, "Type '%s' is not valid.", key);
        return typeValidation;
    }

    private static class TypeValidationMatchKey
    implements Predicate<TypeValidation> {
        private final String key;

        public TypeValidationMatchKey(String key) {
            this.key = key;
        }

        public boolean apply(@Nonnull TypeValidation input) {
            return input.key().equals(this.key);
        }
    }
}

