/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.webhook.ws;

import java.net.InetAddress;
import java.net.UnknownHostException;
import okhttp3.HttpUrl;
import org.sonar.api.config.Configuration;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.process.ProcessProperties;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.user.UserSession;

public class WebhookSupport {
    private final UserSession userSession;
    private final Configuration configuration;

    public WebhookSupport(UserSession userSession, Configuration configuration) {
        this.userSession = userSession;
        this.configuration = configuration;
    }

    void checkPermission(ComponentDto componentDto) {
        this.userSession.checkComponentPermission("admin", componentDto);
    }

    void checkPermission(OrganizationDto organizationDto) {
        this.userSession.checkPermission(OrganizationPermission.ADMINISTER, organizationDto);
    }

    void checkUrlPattern(String url, String message, Object ... messageArguments) {
        try {
            HttpUrl okUrl = HttpUrl.parse((String)url);
            if (okUrl == null) {
                throw new IllegalArgumentException(String.format(message, messageArguments));
            }
            InetAddress address = InetAddress.getByName(okUrl.host());
            if (this.configuration.getBoolean(ProcessProperties.Property.SONAR_VALIDATE_WEBHOOKS.getKey()).orElse(true).booleanValue() && (address.isLoopbackAddress() || address.isAnyLocalAddress())) {
                throw new IllegalArgumentException("Invalid URL: loopback and wildcard addresses are not allowed for webhooks.");
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    void checkThatProjectBelongsToOrganization(ComponentDto componentDto, OrganizationDto organizationDto, String message, Object ... messageArguments) {
        if (!organizationDto.getUuid().equals(componentDto.getOrganizationUuid())) {
            throw new NotFoundException(String.format(message, messageArguments));
        }
    }
}

