/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ws;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sonar.api.server.ws.Request;
import org.sonar.api.web.ServletFilter;
import org.sonar.server.ws.ServletRequest;
import org.sonar.server.ws.ServletResponse;
import org.sonar.server.ws.WebServiceEngine;

public class WebServiceReroutingFilter
extends ServletFilter {
    private static final Map<String, String> REDIRECTS = ImmutableMap.builder().put((Object)"/api/components/bulk_update_key", (Object)"/api/projects/bulk_update_key").put((Object)"/api/components/update_key", (Object)"/api/projects/update_key").build();
    static final Set<String> MOVED_WEB_SERVICES = REDIRECTS.keySet();
    private final WebServiceEngine webServiceEngine;

    public WebServiceReroutingFilter(WebServiceEngine webServiceEngine) {
        this.webServiceEngine = webServiceEngine;
    }

    public ServletFilter.UrlPattern doGetPattern() {
        return ServletFilter.UrlPattern.builder().includes(MOVED_WEB_SERVICES).build();
    }

    public void doFilter(javax.servlet.ServletRequest servletRequest, javax.servlet.ServletResponse servletResponse, FilterChain chain) {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        RedirectionRequest wsRequest = new RedirectionRequest(httpRequest);
        ServletResponse wsResponse = new ServletResponse((HttpServletResponse)servletResponse);
        this.webServiceEngine.execute((Request)wsRequest, wsResponse);
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    private static class RedirectionRequest
    extends ServletRequest {
        private final String redirectedPath;

        public RedirectionRequest(HttpServletRequest source) {
            super(source);
            this.redirectedPath = REDIRECTS.getOrDefault(source.getServletPath(), source.getServletPath());
        }

        @Override
        public String getPath() {
            return this.redirectedPath;
        }
    }
}

