/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ws.ws;

import com.google.common.base.Preconditions;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.server.ws.ws.WebServicesWsAction;

public class ResponseExampleAction
implements WebServicesWsAction {
    private WebService.Context context;

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("response_example").setDescription("Display web service response example").setResponseExample(this.getClass().getResource("response_example-example.json")).setSince("4.4").setHandler((RequestHandler)this);
        action.createParam("controller").setRequired(true).setDescription("Controller of the web service").setExampleValue((Object)"api/issues");
        action.createParam("action").setRequired(true).setDescription("Action of the web service").setExampleValue((Object)"search");
    }

    public void handle(Request request, Response response) throws Exception {
        Preconditions.checkState((this.context != null ? 1 : 0) != 0, (Object)"Webservice global context must be loaded before calling the action");
        String controllerKey = request.mandatoryParam("controller");
        WebService.Controller controller = this.context.controller(controllerKey);
        Preconditions.checkArgument((controller != null ? 1 : 0) != 0, (String)"Controller does not exist: %s", (Object[])new Object[]{controllerKey});
        String actionKey = request.mandatoryParam("action");
        WebService.Action action = controller.action(actionKey);
        Preconditions.checkArgument((action != null ? 1 : 0) != 0, (String)"Action does not exist: %s", (Object[])new Object[]{actionKey});
        if (action.responseExample() == null) {
            response.noContent();
            return;
        }
        try (JsonWriter json = response.newJsonWriter();){
            json.beginObject().prop("format", action.responseExampleFormat()).prop("example", action.responseExampleAsString()).endObject();
        }
    }

    @Override
    public void setContext(WebService.Context context) {
        this.context = context;
    }
}

