/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.charset;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.db.DatabaseUtils;

public class SqlExecutor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> select(Connection connection, String sql, RowConverter<T> rowConverter) throws SQLException {
        ArrayList<T> arrayList;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.prepareStatement(sql);
            rs = stmt.executeQuery();
            ArrayList<T> result = new ArrayList<T>();
            while (rs.next()) {
                result.add(rowConverter.convert(rs));
            }
            arrayList = result;
        }
        catch (Throwable throwable) {
            DatabaseUtils.closeQuietly(rs);
            DatabaseUtils.closeQuietly((Statement)stmt);
            throw throwable;
        }
        DatabaseUtils.closeQuietly((ResultSet)rs);
        DatabaseUtils.closeQuietly((Statement)stmt);
        return arrayList;
    }

    public void executeDdl(Connection connection, String sql) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            stmt.execute(sql);
        }
    }

    @CheckForNull
    public final String selectSingleString(Connection connection, String sql) throws SQLException {
        String[] cols = this.selectSingleRow(connection, sql, new StringsConverter(1));
        return cols == null ? null : cols[0];
    }

    @CheckForNull
    public final <T> T selectSingleRow(Connection connection, String sql, RowConverter<T> rowConverter) throws SQLException {
        List<T> rows = this.select(connection, sql, rowConverter);
        if (rows.isEmpty()) {
            return null;
        }
        if (rows.size() == 1) {
            return rows.get(0);
        }
        throw new IllegalStateException("Expecting only one result for [" + sql + "]");
    }

    public static class StringsConverter
    implements RowConverter<String[]> {
        private final int nbColumns;

        public StringsConverter(int nbColumns) {
            this.nbColumns = nbColumns;
        }

        @Override
        public String[] convert(ResultSet rs) throws SQLException {
            String[] row = new String[this.nbColumns];
            for (int i = 0; i < this.nbColumns; ++i) {
                row[i] = DatabaseUtils.getString((ResultSet)rs, (int)(i + 1));
            }
            return row;
        }
    }

    @FunctionalInterface
    public static interface RowConverter<T> {
        public T convert(ResultSet var1) throws SQLException;
    }
}

