/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.def;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.db.dialect.Dialect;
import org.sonar.server.platform.db.migration.def.AbstractColumnDef;
import org.sonar.server.platform.db.migration.def.Validations;

@Immutable
public class IntegerColumnDef
extends AbstractColumnDef {
    private IntegerColumnDef(Builder builder) {
        super(builder.columnName, builder.isNullable, builder.defaultValue);
    }

    public static Builder newIntegerColumnDefBuilder() {
        return new Builder();
    }

    @Override
    public String generateSqlType(Dialect dialect) {
        switch (dialect.getId()) {
            case "postgresql": 
            case "mysql": 
            case "h2": {
                return "INTEGER";
            }
            case "mssql": {
                return "INT";
            }
            case "oracle": {
                return "NUMBER(38,0)";
            }
        }
        throw new IllegalArgumentException("Unsupported dialect id " + dialect.getId());
    }

    public static class Builder {
        @CheckForNull
        private String columnName;
        private boolean isNullable = true;
        @CheckForNull
        private Integer defaultValue = null;

        public Builder setColumnName(String columnName) {
            this.columnName = Validations.validateColumnName(columnName);
            return this;
        }

        public Builder setIsNullable(boolean isNullable) {
            this.isNullable = isNullable;
            return this;
        }

        public Builder setDefaultValue(@Nullable Integer i) {
            this.defaultValue = i;
            return this;
        }

        public IntegerColumnDef build() {
            Validations.validateColumnName(this.columnName);
            return new IntegerColumnDef(this);
        }
    }
}

