/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.engine;

import java.util.List;
import java.util.Optional;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.core.platform.ComponentContainer;
import org.sonar.process.ProcessProperties;
import org.sonar.server.platform.db.migration.SupportsBlueGreen;
import org.sonar.server.platform.db.migration.engine.MigrationContainerImpl;
import org.sonar.server.platform.db.migration.engine.MigrationContainerPopulator;
import org.sonar.server.platform.db.migration.engine.MigrationEngine;
import org.sonar.server.platform.db.migration.history.MigrationHistory;
import org.sonar.server.platform.db.migration.step.MigrationSteps;
import org.sonar.server.platform.db.migration.step.MigrationStepsExecutor;
import org.sonar.server.platform.db.migration.step.RegisteredMigrationStep;

public class MigrationEngineImpl
implements MigrationEngine {
    private final MigrationHistory migrationHistory;
    private final ComponentContainer serverContainer;
    private final MigrationContainerPopulator populator;
    private final MigrationSteps migrationSteps;
    private final Configuration configuration;

    public MigrationEngineImpl(MigrationHistory migrationHistory, ComponentContainer serverContainer, MigrationContainerPopulator populator, MigrationSteps migrationSteps, Configuration configuration) {
        this.migrationHistory = migrationHistory;
        this.serverContainer = serverContainer;
        this.populator = populator;
        this.migrationSteps = migrationSteps;
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        MigrationContainerImpl migrationContainer = new MigrationContainerImpl(this.serverContainer, this.populator);
        boolean blueGreen = this.configuration.getBoolean(ProcessProperties.Property.BLUE_GREEN_ENABLED.getKey()).orElse(false);
        try {
            MigrationStepsExecutor stepsExecutor = (MigrationStepsExecutor)migrationContainer.getComponentByType(MigrationStepsExecutor.class);
            Optional<Long> lastMigrationNumber = this.migrationHistory.getLastMigrationNumber();
            List<RegisteredMigrationStep> steps = lastMigrationNumber.map(i -> this.migrationSteps.readFrom(i + 1L)).orElse(this.migrationSteps.readAll());
            if (blueGreen) {
                MigrationEngineImpl.ensureSupportBlueGreen(steps);
            }
            stepsExecutor.execute(steps);
        }
        finally {
            migrationContainer.cleanup();
        }
    }

    private static void ensureSupportBlueGreen(List<RegisteredMigrationStep> steps) {
        for (RegisteredMigrationStep step : steps) {
            if (AnnotationUtils.getAnnotation(step.getStepClass(), SupportsBlueGreen.class) != null) continue;
            throw new IllegalStateException(String.format("All migrations canceled. #%d does not support blue/green deployment: %s", step.getMigrationNumber(), step.getDescription()));
        }
    }
}

