/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.history;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.Database;
import org.sonar.db.DatabaseUtils;
import org.sonar.server.platform.db.migration.def.VarcharColumnDef;
import org.sonar.server.platform.db.migration.history.MigrationHistoryTable;
import org.sonar.server.platform.db.migration.sql.CreateTableBuilder;

public class MigrationHistoryTableImpl
implements MigrationHistoryTable {
    private static final String VERSION_COLUMN_NAME = "version";
    private final Database database;

    public MigrationHistoryTableImpl(Database database) {
        this.database = database;
    }

    @Override
    public void start() {
        try (Connection connection = MigrationHistoryTableImpl.createDdlConnection(this.database);){
            if (!DatabaseUtils.tableExists((String)"schema_migrations", (Connection)connection)) {
                this.createTable(connection);
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("Failed to create table schema_migrations", e);
        }
    }

    private void createTable(Connection connection) throws SQLException {
        List<String> sqls = new CreateTableBuilder(this.database.getDialect(), "schema_migrations").addColumn(VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName(VERSION_COLUMN_NAME).setIsNullable(false).setLimit(255).build()).build();
        Loggers.get(MigrationHistoryTableImpl.class).info("Creating table schema_migrations");
        for (String sql : sqls) {
            MigrationHistoryTableImpl.execute(connection, sql);
        }
    }

    private static Connection createDdlConnection(Database database) throws SQLException {
        Connection res = database.getDataSource().getConnection();
        res.setAutoCommit(false);
        return res;
    }

    private static void execute(Connection connection, String sql) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            stmt.execute(sql);
            connection.commit();
        }
    }

    public void stop() {
    }
}

