/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.step;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import javax.annotation.Nullable;
import org.apache.commons.dbutils.DbUtils;
import org.sonar.db.dialect.Dialect;
import org.sonar.server.platform.db.migration.step.SqlStatement;

class BaseSqlStatement<CHILD extends SqlStatement>
implements SqlStatement<CHILD> {
    private final Dialect dialect;
    protected PreparedStatement pstmt;

    protected BaseSqlStatement(Dialect dialect, PreparedStatement pstmt) {
        this.dialect = dialect;
        this.pstmt = pstmt;
    }

    @Override
    public void close() {
        DbUtils.closeQuietly((Statement)this.pstmt);
        this.pstmt = null;
    }

    @Override
    public CHILD setString(int columnIndex, @Nullable String value) throws SQLException {
        this.pstmt.setString(columnIndex, value);
        return (CHILD)this;
    }

    @Override
    public CHILD setInt(int columnIndex, @Nullable Integer value) throws SQLException {
        if (value == null) {
            this.pstmt.setNull(columnIndex, 4);
        } else {
            this.pstmt.setInt(columnIndex, value);
        }
        return (CHILD)this;
    }

    @Override
    public CHILD setLong(int columnIndex, @Nullable Long value) throws SQLException {
        if (value == null) {
            this.pstmt.setNull(columnIndex, -5);
        } else {
            this.pstmt.setLong(columnIndex, value);
        }
        return (CHILD)this;
    }

    @Override
    public CHILD setBoolean(int columnIndex, @Nullable Boolean value) throws SQLException {
        if (value == null) {
            this.pstmt.setNull(columnIndex, 16);
        } else {
            this.pstmt.setBoolean(columnIndex, value);
        }
        return (CHILD)this;
    }

    @Override
    public CHILD setBytes(int columnIndex, @Nullable byte[] value) throws SQLException {
        if (value == null) {
            this.pstmt.setNull(columnIndex, -2);
        } else {
            this.pstmt.setBytes(columnIndex, value);
        }
        return (CHILD)this;
    }

    @Override
    public CHILD setDouble(int columnIndex, @Nullable Double value) throws SQLException {
        if (value == null) {
            this.pstmt.setNull(columnIndex, "mssql".equals(this.dialect.getId()) ? 8 : 3);
        } else {
            this.pstmt.setDouble(columnIndex, value);
        }
        return (CHILD)this;
    }

    @Override
    public CHILD setDate(int columnIndex, @Nullable Date value) throws SQLException {
        if (value == null) {
            this.pstmt.setNull(columnIndex, 93);
        } else {
            this.pstmt.setTimestamp(columnIndex, new Timestamp(value.getTime()));
        }
        return (CHILD)this;
    }
}

