/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.step;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.db.dialect.Dialect;
import org.sonar.server.platform.db.migration.step.BaseSqlStatement;
import org.sonar.server.platform.db.migration.step.Upsert;

public class UpsertImpl
extends BaseSqlStatement<Upsert>
implements Upsert {
    private static final int MAX_BATCH_SIZE = 250;
    private int maxBatchSize = 250;
    private long batchCount = 0L;

    private UpsertImpl(Dialect dialect, PreparedStatement pstmt) {
        super(dialect, pstmt);
    }

    @Override
    public Upsert setBatchSize(int i) {
        Preconditions.checkArgument((i >= 0 ? 1 : 0) != 0, (String)"size must be positive. Got %s", (Object[])new Object[]{i});
        this.maxBatchSize = i;
        return this;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    @Override
    public boolean addBatch() throws SQLException {
        this.pstmt.addBatch();
        this.pstmt.clearParameters();
        ++this.batchCount;
        if (this.batchCount % (long)this.maxBatchSize == 0L) {
            this.pstmt.executeBatch();
            this.pstmt.getConnection().commit();
            return true;
        }
        return false;
    }

    @Override
    public Upsert execute() throws SQLException {
        if (this.batchCount == 0L) {
            this.pstmt.execute();
        } else {
            this.pstmt.executeBatch();
        }
        return this;
    }

    public long getBatchCount() {
        return this.batchCount;
    }

    @Override
    public Upsert commit() throws SQLException {
        this.pstmt.getConnection().commit();
        return this;
    }

    public static UpsertImpl create(Database db, Connection connection, String sql) throws SQLException {
        return new UpsertImpl(db.getDialect(), connection.prepareStatement(sql));
    }
}

