/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v60;

import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class PopulateAnalysisUuidColumnOnCeActivity
extends DataChange {
    public PopulateAnalysisUuidColumnOnCeActivity(Database db) {
        super(db);
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("SELECT a.id, s.uuid from ce_activity a inner join snapshots s on s.id=a.snapshot_id where a.snapshot_id is not null and a.analysis_uuid is null");
        massUpdate.update("UPDATE ce_activity SET analysis_uuid=? WHERE id=?");
        massUpdate.rowPluralName("ce_activity");
        massUpdate.execute(PopulateAnalysisUuidColumnOnCeActivity::handle);
    }

    private static boolean handle(Select.Row row, SqlStatement update) throws SQLException {
        long id = row.getLong(1);
        String analysisUuid = row.getString(2);
        update.setString(1, analysisUuid);
        update.setLong(2, id);
        return true;
    }
}

