/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v60;

import com.google.common.base.Throwables;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class PopulateUserUpdatedAtOfRulesProfiles
extends DataChange {
    private static final String SQL_SELECT_PROFILES_NOT_UPDATED = "select kee from rules_profiles where user_updated_at is null";

    public PopulateUserUpdatedAtOfRulesProfiles(Database db) {
        super(db);
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        Map<String, Long> userUpdatedAtByProfileKeys = PopulateUserUpdatedAtOfRulesProfiles.buildUserUpdatedAtMap(context);
        PopulateUserUpdatedAtOfRulesProfiles.populateUserUpdatedAtColumn(context, userUpdatedAtByProfileKeys);
    }

    private static Map<String, Long> buildUserUpdatedAtMap(DataChange.Context context) throws SQLException {
        HashMap<String, Long> lastAnalysisDatesByQPKeys = new HashMap<String, Long>();
        List<String> profileKeys = context.prepareSelect(SQL_SELECT_PROFILES_NOT_UPDATED).list(row -> row.getString(1));
        profileKeys.forEach(profileKey -> lastAnalysisDatesByQPKeys.put((String)profileKey, PopulateUserUpdatedAtOfRulesProfiles.getUserUpdateAt(context, profileKey)));
        return lastAnalysisDatesByQPKeys;
    }

    @CheckForNull
    private static Long getUserUpdateAt(DataChange.Context context, String profileKey) {
        try {
            return ((Select)context.prepareSelect("select created_at as \"createdAt\" from activities where user_login is not null   and profile_key=? order by created_at DESC ").setString(1, profileKey)).get(row -> {
                Date userUpdatedAt = row.getNullableDate(1);
                return userUpdatedAt == null ? null : Long.valueOf(userUpdatedAt.getTime());
            });
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static void populateUserUpdatedAtColumn(DataChange.Context context, Map<String, Long> userUpdatedAdByProfileKey) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select(SQL_SELECT_PROFILES_NOT_UPDATED);
        massUpdate.update("update rules_profiles set user_updated_at=? where kee=?");
        massUpdate.rowPluralName("quality profiles");
        massUpdate.execute((Select.Row row, SqlStatement update) -> PopulateUserUpdatedAtOfRulesProfiles.handle(userUpdatedAdByProfileKey, row, update));
    }

    private static boolean handle(Map<String, Long> userUpdatedAtByProfileKey, Select.Row row, SqlStatement update) throws SQLException {
        String profileKey = row.getString(1);
        update.setLong(1, userUpdatedAtByProfileKey.get(profileKey));
        update.setString(2, profileKey);
        return true;
    }
}

