/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v61;

import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class DeleteProjectDashboards
extends DataChange {
    public DeleteProjectDashboards(Database db) {
        super(db);
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        DeleteProjectDashboards.deleteWidgetProperties(context);
        DeleteProjectDashboards.deleteDashboardsAndWidgets(context);
    }

    private static void deleteWidgetProperties(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("SELECT w.id FROM widgets w  INNER JOIN dashboards d on w.dashboard_id=d.id WHERE d.is_global=?").setBoolean(1, false);
        massUpdate.update("DELETE from widget_properties WHERE widget_id=?");
        massUpdate.rowPluralName("delete widget properties of project dashboards");
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            update.setLong(1, row.getLong(1));
            return true;
        });
    }

    private static void deleteDashboardsAndWidgets(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("SELECT id FROM dashboards d WHERE d.is_global=?").setBoolean(1, false);
        massUpdate.update("DELETE from widgets WHERE dashboard_id=?");
        massUpdate.update("DELETE from active_dashboards WHERE dashboard_id=?");
        massUpdate.update("DELETE from dashboards WHERE id=?");
        massUpdate.rowPluralName("delete project dashboards");
        massUpdate.execute((Select.Row row, SqlStatement update, int updateIndex) -> {
            long dashboardId = row.getLong(1);
            switch (updateIndex) {
                case 0: 
                case 1: 
                case 2: {
                    update.setLong(1, dashboardId);
                    return true;
                }
            }
            throw new IllegalArgumentException("Unsupported update index " + updateIndex);
        });
    }
}

