/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v62;

import java.sql.SQLException;
import org.sonar.api.utils.System2;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.Upsert;

public class CreateDefaultOrganization
extends DataChange {
    private static final String KEY_DEFAULT_ORGANIZATION = "default-organization";
    private static final String INTERNAL_PROPERTY_DEFAULT_ORGANIZATION = "organization.default";
    private final System2 system2;
    private final UuidFactory uuidFactory;

    public CreateDefaultOrganization(Database db, System2 system2, UuidFactory uuidFactory) {
        super(db);
        this.system2 = system2;
        this.uuidFactory = uuidFactory;
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        String uuid = this.createDefaultOrganization(context);
        this.saveDefaultOrganizationUuid(context, uuid);
    }

    private String createDefaultOrganization(DataChange.Context context) throws SQLException {
        Select select = context.prepareSelect("select uuid from organizations where kee=?");
        select.setString(1, KEY_DEFAULT_ORGANIZATION);
        String uuid = select.get(row -> row.getNullableString(1));
        if (uuid == null) {
            uuid = this.uuidFactory.create();
            long now = this.system2.now();
            ((Upsert)((Upsert)((Upsert)((Upsert)((Upsert)context.prepareUpsert("insert into organizations (uuid, kee, name, created_at, updated_at) values (?, ?, ?, ?, ?)").setString(1, uuid)).setString(2, KEY_DEFAULT_ORGANIZATION)).setString(3, "Default Organization")).setLong(4, now)).setLong(5, now)).execute().commit();
        }
        return uuid;
    }

    private void saveDefaultOrganizationUuid(DataChange.Context context, String uuid) throws SQLException {
        Select select = context.prepareSelect("select kee from internal_properties where kee=?");
        select.setString(1, INTERNAL_PROPERTY_DEFAULT_ORGANIZATION);
        if (select.get(row -> row.getNullableString(1)) == null) {
            ((Upsert)((Upsert)((Upsert)((Upsert)context.prepareUpsert("insert into internal_properties (kee, is_empty, text_value, created_at) values (?, ?, ?, ?)").setString(1, INTERNAL_PROPERTY_DEFAULT_ORGANIZATION)).setBoolean(2, false)).setString(3, uuid)).setLong(4, this.system2.now())).execute().commit();
        }
    }
}

