/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v65;

import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class CleanOrphanRowsInProperties
extends DataChange {
    private static final String SCOPE_PROJECT = "PRJ";
    private static final String QUALIFIER_PROJECT = "TRK";
    private static final String QUALIFIER_VIEW = "VW";
    private static final String QUALIFIER_MODULE = "BRC";
    private static final String QUALIFIER_SUBVIEW = "SVW";

    public CleanOrphanRowsInProperties(Database db) {
        super(db);
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select   s.id from properties s where   s.resource_id is not null   and not exists (     select       1     from projects p     where       p.id = s.resource_id       and p.scope = ?       and p.qualifier in (?,?,?,?)       and p.enabled = ?  )").setString(1, SCOPE_PROJECT).setString(2, QUALIFIER_PROJECT).setString(3, QUALIFIER_VIEW).setString(4, QUALIFIER_MODULE).setString(5, QUALIFIER_SUBVIEW).setBoolean(6, true);
        massUpdate.update("delete from properties where id = ?");
        massUpdate.rowPluralName("orphan properties");
        massUpdate.execute(CleanOrphanRowsInProperties::handle);
    }

    private static boolean handle(Select.Row row, SqlStatement update) throws SQLException {
        long id = row.getLong(1);
        update.setLong(1, id);
        return true;
    }
}

