/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v65;

import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class PurgeDeveloperData
extends DataChange {
    public PurgeDeveloperData(Database db) {
        super(db);
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        this.purgeProjectCopies(context);
        this.purgeDevelopers(context);
    }

    private void purgeProjectCopies(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select   child.id, child.uuid from projects child inner join projects root on   root.uuid = child.project_uuid   and root.scope=?   and root.qualifier=? where   child.uuid <> child.project_uuid").setString(1, "PRJ").setString(2, "DEV");
        massUpdate.rowPluralName("purged project copies");
        massUpdate.update("delete from project_measures where component_uuid=?");
        massUpdate.update("delete from projects where uuid=?");
        massUpdate.execute(PurgeDeveloperData::handlePurgeProjectCopies);
    }

    private static boolean handlePurgeProjectCopies(Select.Row row, SqlStatement update, int updateIndex) throws SQLException {
        if (updateIndex < 0 || updateIndex > 1) {
            throw new IllegalArgumentException("Unsupported updateIndex " + updateIndex);
        }
        String uuid = row.getString(2);
        update.setString(1, uuid);
        return true;
    }

    private void purgeDevelopers(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select   id, uuid from projects where   scope=?   and qualifier=?").setString(1, "PRJ").setString(2, "DEV");
        massUpdate.update("delete from project_measures where component_uuid=?");
        massUpdate.update("delete from ce_activity where component_uuid=?");
        massUpdate.update("delete from snapshots where component_uuid=?");
        massUpdate.update("delete from group_roles where resource_id=?");
        massUpdate.update("delete from user_roles where resource_id=?");
        massUpdate.update("delete from projects where project_uuid=?");
        massUpdate.rowPluralName("purged developers");
        massUpdate.execute(PurgeDeveloperData::handlePurgeDevelopers);
    }

    private static boolean handlePurgeDevelopers(Select.Row row, SqlStatement update, int updateIndex) throws SQLException {
        long id = row.getLong(1);
        String uuid = row.getString(2);
        switch (updateIndex) {
            case 0: 
            case 1: 
            case 2: {
                update.setString(1, uuid);
                return true;
            }
            case 3: 
            case 4: {
                update.setLong(1, id);
                return true;
            }
            case 5: {
                update.setString(1, uuid);
                return true;
            }
        }
        throw new IllegalArgumentException("Unsupported updateIndex " + updateIndex);
    }
}

