/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v65;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class SetRulesProfilesIsBuiltInToTrueForDefaultOrganization
extends DataChange {
    private static final String PROP_DEFAULT_ORGANIZATION_UUID = "organization.default";
    private static final String PROP_ORGANIZATION_ENABLED = "organization.enabled";

    public SetRulesProfilesIsBuiltInToTrueForDefaultOrganization(Database db) {
        super(db);
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        if (!SetRulesProfilesIsBuiltInToTrueForDefaultOrganization.isOrganizationEnabled(context)) {
            return;
        }
        String defaultOrganizationUuid = SetRulesProfilesIsBuiltInToTrueForDefaultOrganization.getDefaultOrganizationUuid(context);
        Preconditions.checkState((defaultOrganizationUuid != null ? 1 : 0) != 0, (String)"Missing internal property: '%s'", (Object[])new Object[]{PROP_DEFAULT_ORGANIZATION_UUID});
        MassUpdate massUpdate = context.prepareMassUpdate().rowPluralName("rules profiles");
        massUpdate.select("select rp.kee from rules_profiles rp inner join org_qprofiles oqp on rp.kee = oqp.rules_profile_uuid where oqp.organization_uuid = ? ").setString(1, defaultOrganizationUuid);
        massUpdate.update("update rules_profiles set is_built_in=? where kee=?");
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            String rulesProfilesUuid = row.getString(1);
            update.setBoolean(1, true);
            update.setString(2, rulesProfilesUuid);
            return true;
        });
    }

    private static String getDefaultOrganizationUuid(DataChange.Context context) throws SQLException {
        return ((Select)context.prepareSelect("select text_value from internal_properties where kee=?").setString(1, PROP_DEFAULT_ORGANIZATION_UUID)).get(row -> row.getString(1));
    }

    private static boolean isOrganizationEnabled(DataChange.Context context) throws SQLException {
        String value = ((Select)context.prepareSelect("select text_value from internal_properties where kee=?").setString(1, PROP_ORGANIZATION_ENABLED)).get(row -> row.getNullableString(1));
        return "true".equals(value);
    }
}

