/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v66;

import java.sql.SQLException;
import org.sonar.api.utils.System2;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class FixEmptyIdentityProviderInUsers
extends DataChange {
    private static final String SQ_AUTHORITY = "sonarqube";
    private final System2 system2;

    public FixEmptyIdentityProviderInUsers(Database db, System2 system2) {
        super(db);
        this.system2 = system2;
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        long now = this.system2.now();
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select u.id, u.login from users u where u.external_identity is null or u.external_identity_provider is null");
        massUpdate.update("update users set external_identity = ?, external_identity_provider = ?, updated_at = ? where id = ?");
        massUpdate.rowPluralName("users without external identity information");
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            update.setString(1, row.getString(2));
            update.setString(2, SQ_AUTHORITY);
            update.setLong(3, now);
            update.setLong(4, row.getLong(1));
            return true;
        });
    }
}

