/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v70;

import java.sql.SQLException;
import java.util.Date;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class RenameOldSonarQubeWayQualityGate
extends DataChange {
    private static final Logger LOG = Loggers.get(RenameOldSonarQubeWayQualityGate.class);
    private static final String SONARQUBE_WAY_QUALITY_GATE = "SonarQube way";
    private static final String SONARQUBE_WAY_QUALITY_GATE_OUTDATED = "Sonar way (outdated copy)";
    private final System2 system2;

    public RenameOldSonarQubeWayQualityGate(Database db, System2 system2) {
        super(db);
        this.system2 = system2;
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        try {
            MassUpdate massUpdate = context.prepareMassUpdate();
            massUpdate.select("SELECT id FROM quality_gates WHERE name = ?").setString(1, SONARQUBE_WAY_QUALITY_GATE);
            massUpdate.rowPluralName("quality gates");
            massUpdate.update("UPDATE quality_gates SET name=?, is_built_in=?, updated_at=? WHERE id=?");
            massUpdate.execute((Select.Row row, SqlStatement update) -> {
                update.setString(1, SONARQUBE_WAY_QUALITY_GATE_OUTDATED);
                update.setBoolean(2, false);
                update.setDate(3, new Date(this.system2.now()));
                update.setLong(4, row.getLong(1));
                return true;
            });
        }
        catch (Exception ex) {
            LOG.error("There is already a quality profile with name [{}]", (Object)SONARQUBE_WAY_QUALITY_GATE_OUTDATED);
            throw ex;
        }
    }
}

