/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v71;

import java.sql.SQLException;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class UpdatePermissionTooLongTemplateKeys
extends DataChange {
    private final String lengthFunction;
    private final UuidFactory uuidFactory;

    public UpdatePermissionTooLongTemplateKeys(Database db, UuidFactory uuidFactory) {
        super(db);
        this.uuidFactory = uuidFactory;
        this.lengthFunction = db.getDialect().getId().equals("mssql") ? "len" : "length";
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select kee from permission_templates where " + this.lengthFunction + "(kee) > ?").setInt(1, 40);
        massUpdate.update("update permission_templates set kee=? where kee=?");
        massUpdate.rowPluralName("permission templates");
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            String oldKey = row.getString(1);
            String newKey = this.uuidFactory.create();
            update.setString(1, newKey);
            update.setString(2, oldKey);
            return true;
        });
    }
}

