/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v72;

import java.sql.SQLException;
import org.sonar.api.utils.System2;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class FixDuplicationInExternalLoginOnUsers
extends DataChange {
    private final System2 system2;

    public FixDuplicationInExternalLoginOnUsers(Database db, System2 system2) {
        super(db);
        this.system2 = system2;
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate().rowPluralName("users having duplicated values in EXTERNAL_LOGIN");
        massUpdate.select("SELECT u1.id, u1.login FROM users u1 WHERE EXISTS (SELECT 1 FROM users u2 WHERE u2.external_login = u1.external_login AND u2.id != u1.id)");
        massUpdate.update("UPDATE users SET external_login=?, external_id=?, updated_at=? WHERE id=?");
        long now = this.system2.now();
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            long id = row.getLong(1);
            String login = row.getString(2);
            update.setString(1, login);
            update.setString(2, login);
            update.setLong(3, now);
            update.setLong(4, id);
            return true;
        });
    }
}

