/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v72;

import java.sql.SQLException;
import org.sonar.api.utils.System2;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class PopulateUUIDOnUsers
extends DataChange {
    private final System2 system2;
    private final UuidFactory uuidFactory;

    public PopulateUUIDOnUsers(Database db, System2 system2, UuidFactory uuidFactory) {
        super(db);
        this.system2 = system2;
        this.uuidFactory = uuidFactory;
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select id, login from users where uuid is null");
        massUpdate.rowPluralName("users");
        massUpdate.update("update users set uuid=?, updated_at=? where id=?");
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            String login = row.getString(2);
            if (login == null) {
                login = this.uuidFactory.create();
            }
            update.setString(1, login);
            update.setLong(2, this.system2.now());
            update.setLong(3, row.getLong(1));
            return true;
        });
    }
}

