/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v74;

import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.def.VarcharColumnDef;
import org.sonar.server.platform.db.migration.sql.AddColumnsBuilder;
import org.sonar.server.platform.db.migration.sql.CreateIndexBuilder;
import org.sonar.server.platform.db.migration.step.DdlChange;

abstract class AddTmpColumnsToCeTable
extends DdlChange {
    private static final VarcharColumnDef COLUMN_TMP_COMPONENT_UUID = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("tmp_component_uuid").setLimit(40).setIsNullable(true).build();
    private static final VarcharColumnDef COLUMN_TMP_MAIN_COMPONENT_UUID = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("tmp_main_component_uuid").setLimit(40).setIsNullable(true).build();
    private final String tableName;

    public AddTmpColumnsToCeTable(Database db, String tableName) {
        super(db);
        this.tableName = tableName;
    }

    @Override
    public void execute(DdlChange.Context context) throws SQLException {
        context.execute(new AddColumnsBuilder(this.getDialect(), this.tableName).addColumn(COLUMN_TMP_MAIN_COMPONENT_UUID).addColumn(COLUMN_TMP_COMPONENT_UUID).build());
        context.execute(new CreateIndexBuilder(this.getDialect()).setTable(this.tableName).setName(this.tableName + "_tmp_cpnt_uuid").addColumn(COLUMN_TMP_COMPONENT_UUID).setUnique(false).build());
        context.execute(new CreateIndexBuilder(this.getDialect()).setTable(this.tableName).setName(this.tableName + "_tmp_main_cpnt_uuid").addColumn(COLUMN_TMP_MAIN_COMPONENT_UUID).setUnique(false).build());
    }
}

