/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v74;

import java.sql.SQLException;
import org.sonar.api.utils.System2;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.SupportsBlueGreen;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

@SupportsBlueGreen
public class PopulateIsAdHocOnRules
extends DataChange {
    private final System2 system2;

    public PopulateIsAdHocOnRules(Database db, System2 system2) {
        super(db);
        this.system2 = system2;
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        long now = this.system2.now();
        MassUpdate massUpdate = context.prepareMassUpdate().rowPluralName("rules");
        massUpdate.select("SELECT r.id, r.is_external FROM rules r WHERE r.is_ad_hoc IS NULL");
        massUpdate.update("UPDATE rules SET is_ad_hoc=?, updated_at=? WHERE id=?");
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            int id = row.getInt(1);
            update.setBoolean(1, row.getBoolean(2));
            update.setLong(2, now);
            update.setInt(3, id);
            return true;
        });
    }
}

