/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v76;

import java.sql.Connection;
import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.db.DatabaseUtils;
import org.sonar.server.platform.db.migration.SupportsBlueGreen;
import org.sonar.server.platform.db.migration.def.BigIntegerColumnDef;
import org.sonar.server.platform.db.migration.def.VarcharColumnDef;
import org.sonar.server.platform.db.migration.sql.CreateTableBuilder;
import org.sonar.server.platform.db.migration.step.DdlChange;

@SupportsBlueGreen
public class CreateUserPropertiesTable
extends DdlChange {
    private static final String TABLE_NAME = "user_properties";
    private static final VarcharColumnDef UUID_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("uuid").setIsNullable(false).setLimit(40).build();
    private static final VarcharColumnDef USER_UUID_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("user_uuid").setIsNullable(false).setLimit(255).build();
    private static final VarcharColumnDef KEY_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("kee").setIsNullable(false).setLimit(100).build();
    private static final VarcharColumnDef TEXT_VALUE_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("text_value").setIsNullable(false).setLimit(4000).build();
    private static final BigIntegerColumnDef CREATED_AT_COLUMN = BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("created_at").setIsNullable(false).build();
    private static final BigIntegerColumnDef UPDATED_AT_COLUMN = BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("updated_at").setIsNullable(false).build();

    public CreateUserPropertiesTable(Database db) {
        super(db);
    }

    @Override
    public void execute(DdlChange.Context context) throws SQLException {
        if (this.tableExists()) {
            return;
        }
        context.execute(new CreateTableBuilder(this.getDialect(), TABLE_NAME).addPkColumn(UUID_COLUMN, new CreateTableBuilder.ColumnFlag[0]).addColumn(USER_UUID_COLUMN).addColumn(KEY_COLUMN).addColumn(TEXT_VALUE_COLUMN).addColumn(CREATED_AT_COLUMN).addColumn(UPDATED_AT_COLUMN).build());
    }

    private boolean tableExists() throws SQLException {
        try (Connection connection = this.getDatabase().getDataSource().getConnection();){
            boolean bl = DatabaseUtils.tableExists((String)TABLE_NAME, (Connection)connection);
            return bl;
        }
    }
}

