/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v76;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.SupportsBlueGreen;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.Upsert;

@SupportsBlueGreen
public class MigrateNoMoreUsedQualityGateConditions
extends DataChange {
    private static final Logger LOG = Loggers.get(MigrateNoMoreUsedQualityGateConditions.class);
    private static final String OPERATOR_GREATER_THAN = "GT";
    private static final String OPERATOR_LESS_THAN = "LT";
    private static final int DIRECTION_WORST = -1;
    private static final int DIRECTION_BETTER = 1;
    private static final int DIRECTION_NONE = 0;
    private static final Set<String> SUPPORTED_OPERATORS = ImmutableSet.of((Object)"GT", (Object)"LT");
    private static final Set<String> SUPPORTED_METRIC_TYPES = ImmutableSet.of((Object)"INT", (Object)"FLOAT", (Object)"PERCENT", (Object)"MILLISEC", (Object)"LEVEL", (Object)"RATING", (Object[])new String[]{"WORK_DUR"});
    private static final Map<String, String> LEAK_METRIC_KEY_BY_METRIC_KEY = ImmutableMap.builder().put((Object)"branch_coverage", (Object)"new_branch_coverage").put((Object)"conditions_to_cover", (Object)"new_conditions_to_cover").put((Object)"coverage", (Object)"new_coverage").put((Object)"line_coverage", (Object)"new_line_coverage").put((Object)"lines_to_cover", (Object)"new_lines_to_cover").put((Object)"uncovered_conditions", (Object)"new_uncovered_conditions").put((Object)"uncovered_lines", (Object)"new_uncovered_lines").put((Object)"duplicated_blocks", (Object)"new_duplicated_blocks").put((Object)"duplicated_lines", (Object)"new_duplicated_lines").put((Object)"duplicated_lines_density", (Object)"new_duplicated_lines_density").put((Object)"blocker_violations", (Object)"new_blocker_violations").put((Object)"critical_violations", (Object)"new_critical_violations").put((Object)"info_violations", (Object)"new_info_violations").put((Object)"violations", (Object)"new_violations").put((Object)"major_violations", (Object)"new_major_violations").put((Object)"minor_violations", (Object)"new_minor_violations").put((Object)"sqale_index", (Object)"new_technical_debt").put((Object)"code_smells", (Object)"new_code_smells").put((Object)"sqale_rating", (Object)"new_maintainability_rating").put((Object)"sqale_debt_ratio", (Object)"new_sqale_debt_ratio").put((Object)"bugs", (Object)"new_bugs").put((Object)"reliability_rating", (Object)"new_reliability_rating").put((Object)"reliability_remediation_effort", (Object)"new_reliability_remediation_effort").put((Object)"vulnerabilities", (Object)"new_vulnerabilities").put((Object)"security_rating", (Object)"new_security_rating").put((Object)"security_remediation_effort", (Object)"new_security_remediation_effort").put((Object)"lines", (Object)"new_lines").build();
    private final System2 system2;

    public MigrateNoMoreUsedQualityGateConditions(Database db, System2 system2) {
        super(db);
        this.system2 = system2;
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        MigrationContext migrationContext = new MigrationContext(context, new Date(this.system2.now()), MigrateNoMoreUsedQualityGateConditions.loadMetrics(context));
        List<Long> qualityGateIds = ((Select)context.prepareSelect("SELECT id FROM quality_gates qg WHERE qg.is_built_in=?").setBoolean(1, false)).list(Select.LONG_READER);
        for (long qualityGateId : qualityGateIds) {
            List<QualityGateCondition> conditions = MigrateNoMoreUsedQualityGateConditions.loadConditions(context, qualityGateId);
            MigrateNoMoreUsedQualityGateConditions.markNoMoreSupportedConditionsAsToBeDeleted(migrationContext, conditions);
            MigrateNoMoreUsedQualityGateConditions.markConditionsHavingOnlyWarningAsToBeDeleted(conditions);
            MigrateNoMoreUsedQualityGateConditions.markConditionsUsingLeakPeriodHavingNoRelatedLeakMetricAsToBeDeleted(migrationContext, conditions);
            MigrateNoMoreUsedQualityGateConditions.markConditionsUsingLeakPeriodUsingSameMetricAsOtherConditionOnOverallAsToBeDeleted(conditions);
            MigrateNoMoreUsedQualityGateConditions.markConditionsUsingLeakPeriodHavingAlreadyRelatedConditionAsToBeDeleted(migrationContext, conditions);
            MigrateNoMoreUsedQualityGateConditions.updateConditionsUsingLeakPeriod(migrationContext, conditions);
            MigrateNoMoreUsedQualityGateConditions.updateConditionsHavingErrorAndWarningByRemovingWarning(migrationContext, conditions);
            MigrateNoMoreUsedQualityGateConditions.dropConditionsIfNeeded(migrationContext, conditions);
            migrationContext.increaseNumberOfProcessedQualityGate();
        }
        LOG.info("{} custom quality gates have been loaded", (Object)migrationContext.getNbOfQualityGates());
        LOG.info("{} conditions have been removed", (Object)migrationContext.getNbOfRemovedConditions());
        LOG.info("{} conditions have been updated", (Object)migrationContext.getNbOfUpdatedConditions());
    }

    private static List<Metric> loadMetrics(DataChange.Context context) throws SQLException {
        return ((Select)context.prepareSelect("SELECT m.id, m.name, m.val_type, m.direction FROM metrics m WHERE m.enabled=?").setBoolean(1, true)).list(row -> new Metric(row.getInt(1), row.getString(2), row.getString(3), row.getInt(4)));
    }

    private static List<QualityGateCondition> loadConditions(DataChange.Context context, long qualityGateId) throws SQLException {
        return ((Select)context.prepareSelect("SELECT qgc.id, qgc.metric_id, qgc.operator, qgc.value_error, qgc.value_warning, qgc.period FROM quality_gate_conditions qgc WHERE qgc.qgate_id=? ").setLong(1, qualityGateId)).list(row -> new QualityGateCondition(row.getInt(1), row.getInt(2), row.getString(3), row.getString(4), row.getString(5), row.getInt(6)));
    }

    private static void markNoMoreSupportedConditionsAsToBeDeleted(MigrationContext migrationContext, List<QualityGateCondition> conditions) {
        conditions.stream().filter(c -> !c.isToBeDeleted()).filter(c -> !MigrateNoMoreUsedQualityGateConditions.isConditionStillSupported(c, migrationContext.getMetricById(c.getMetricId()))).forEach(QualityGateCondition::setToBeDeleted);
    }

    private static void markConditionsHavingOnlyWarningAsToBeDeleted(List<QualityGateCondition> conditions) {
        conditions.stream().filter(c -> !c.isToBeDeleted()).filter(c -> !Strings.isNullOrEmpty((String)c.getWarning()) && Strings.isNullOrEmpty((String)c.getError())).forEach(QualityGateCondition::setToBeDeleted);
    }

    private static void markConditionsUsingLeakPeriodHavingNoRelatedLeakMetricAsToBeDeleted(MigrationContext migrationContext, List<QualityGateCondition> conditions) {
        conditions.stream().filter(c -> !c.isToBeDeleted()).filter(QualityGateCondition::hasLeakPeriod).filter(condition -> !MigrateNoMoreUsedQualityGateConditions.isConditionOnLeakMetric(migrationContext, condition)).forEach(condition -> {
            String metricKey = migrationContext.getMetricById(condition.getMetricId()).getKey();
            String relatedLeakMetric = LEAK_METRIC_KEY_BY_METRIC_KEY.get(metricKey);
            if (relatedLeakMetric == null) {
                condition.setToBeDeleted();
            }
        });
    }

    private static void markConditionsUsingLeakPeriodUsingSameMetricAsOtherConditionOnOverallAsToBeDeleted(List<QualityGateCondition> allConditions) {
        Map<Integer, List<QualityGateCondition>> conditionsByMetricId = allConditions.stream().filter(c -> !c.isToBeDeleted()).collect(Collectors.groupingBy(QualityGateCondition::getMetricId));
        for (List<QualityGateCondition> conditions : conditionsByMetricId.values()) {
            if (conditions.size() <= 1) continue;
            conditions.stream().filter(QualityGateCondition::hasLeakPeriod).forEach(QualityGateCondition::setToBeDeleted);
        }
    }

    private static void markConditionsUsingLeakPeriodHavingAlreadyRelatedConditionAsToBeDeleted(MigrationContext migrationContext, List<QualityGateCondition> conditions) {
        Map conditionsByMetricKey = (Map)conditions.stream().filter(c -> !c.isToBeDeleted()).collect(MoreCollectors.uniqueIndex(c -> migrationContext.getMetricById(c.getMetricId()).getKey()));
        conditions.stream().filter(condition -> !condition.isToBeDeleted()).filter(QualityGateCondition::hasLeakPeriod).filter(condition -> !MigrateNoMoreUsedQualityGateConditions.isConditionOnLeakMetric(migrationContext, condition)).forEach(condition -> {
            QualityGateCondition existingConditionUsingRelatedLeakPeriod;
            String metricKey = migrationContext.getMetricById(condition.getMetricId()).getKey();
            String relatedLeakMetric = LEAK_METRIC_KEY_BY_METRIC_KEY.get(metricKey);
            if (relatedLeakMetric != null && (existingConditionUsingRelatedLeakPeriod = (QualityGateCondition)conditionsByMetricKey.get(relatedLeakMetric)) != null) {
                condition.setToBeDeleted();
            }
        });
    }

    private static void updateConditionsHavingErrorAndWarningByRemovingWarning(MigrationContext migrationContext, List<QualityGateCondition> conditions) throws SQLException {
        Set conditionsToBeUpdated = conditions.stream().filter(c -> !c.isToBeDeleted()).filter(c -> !Strings.isNullOrEmpty((String)c.getWarning()) && !Strings.isNullOrEmpty((String)c.getError())).map(QualityGateCondition::getId).collect(Collectors.toSet());
        if (conditionsToBeUpdated.isEmpty()) {
            return;
        }
        ((Upsert)migrationContext.getContext().prepareUpsert("UPDATE quality_gate_conditions SET value_warning = NULL, updated_at = ? WHERE id IN (" + conditionsToBeUpdated.stream().map(c -> Integer.toString(c)).collect(Collectors.joining(",")) + ")").setDate(1, migrationContext.getNow())).execute().commit();
        migrationContext.addUpdatedConditions(conditionsToBeUpdated.size());
    }

    private static void updateConditionsUsingLeakPeriod(MigrationContext migrationContext, List<QualityGateCondition> conditions) throws SQLException {
        Map conditionsByMetricKey = (Map)conditions.stream().filter(c -> !c.isToBeDeleted()).collect(MoreCollectors.uniqueIndex(c -> migrationContext.getMetricById(c.getMetricId()).getKey()));
        Upsert updateMetricId = (Upsert)migrationContext.getContext().prepareUpsert("UPDATE quality_gate_conditions SET metric_id = ?, updated_at = ? WHERE id = ? ").setDate(2, migrationContext.getNow());
        conditions.stream().filter(c -> !c.isToBeDeleted()).filter(QualityGateCondition::hasLeakPeriod).filter(condition -> !MigrateNoMoreUsedQualityGateConditions.isConditionOnLeakMetric(migrationContext, condition)).forEach(condition -> {
            String metricKey = migrationContext.getMetricById(condition.getMetricId()).getKey();
            String relatedLeakMetric = LEAK_METRIC_KEY_BY_METRIC_KEY.get(metricKey);
            QualityGateCondition existingConditionUsingRelatedLeakPeriod = (QualityGateCondition)conditionsByMetricKey.get(relatedLeakMetric);
            if (existingConditionUsingRelatedLeakPeriod == null) {
                try {
                    updateMetricId.setInt(1, migrationContext.getMetricByKey(relatedLeakMetric).getId());
                    updateMetricId.setInt(3, condition.getId());
                    updateMetricId.execute();
                    migrationContext.addUpdatedConditions(1);
                }
                catch (SQLException e) {
                    throw new IllegalStateException("Fail to update quality gate conditions", e);
                }
            }
        });
        updateMetricId.commit();
    }

    private static void dropConditionsIfNeeded(MigrationContext context, List<QualityGateCondition> conditions) throws SQLException {
        List conditionsToBeDeleted = (List)conditions.stream().filter(QualityGateCondition::isToBeDeleted).collect(MoreCollectors.toList());
        if (conditionsToBeDeleted.isEmpty()) {
            return;
        }
        context.getContext().prepareUpsert("DELETE FROM quality_gate_conditions WHERE id IN (" + conditionsToBeDeleted.stream().map(c -> Integer.toString(c.getId())).collect(Collectors.joining(",")) + ")").execute().commit();
        context.addRemovedConditions(conditionsToBeDeleted.size());
    }

    private static boolean isConditionOnLeakMetric(MigrationContext migrationContext, QualityGateCondition condition) {
        return LEAK_METRIC_KEY_BY_METRIC_KEY.containsValue(migrationContext.getMetricById(condition.getMetricId()).getKey());
    }

    private static boolean isConditionStillSupported(QualityGateCondition condition, Metric metric) {
        return MigrateNoMoreUsedQualityGateConditions.isSupportedMetricType(metric) && MigrateNoMoreUsedQualityGateConditions.isSupportedOperator(condition, metric);
    }

    private static boolean isSupportedMetricType(Metric metric) {
        return SUPPORTED_METRIC_TYPES.contains(metric.getType());
    }

    private static boolean isSupportedOperator(QualityGateCondition condition, Metric metric) {
        String operator = condition.getOperator();
        int direction = metric.getDirection();
        return SUPPORTED_OPERATORS.contains(operator) && (direction == 0 || direction == -1 && operator.equalsIgnoreCase(OPERATOR_GREATER_THAN) || direction == 1 && operator.equalsIgnoreCase(OPERATOR_LESS_THAN));
    }

    private static class MigrationContext {
        private final DataChange.Context context;
        private final Date now;
        private final Map<Integer, Metric> metricsById;
        private final Map<String, Metric> metricsByKey;
        private int nbOfQualityGates;
        private int nbOfRemovedConditions;
        private int nbOfUpdatedConditions;

        public MigrationContext(DataChange.Context context, Date now, List<Metric> metrics) {
            this.context = context;
            this.now = now;
            this.metricsById = (Map)metrics.stream().collect(MoreCollectors.uniqueIndex(Metric::getId));
            this.metricsByKey = (Map)metrics.stream().collect(MoreCollectors.uniqueIndex(Metric::getKey));
        }

        public DataChange.Context getContext() {
            return this.context;
        }

        public Date getNow() {
            return this.now;
        }

        public Metric getMetricByKey(String key) {
            return this.metricsByKey.get(key);
        }

        public Metric getMetricById(int id) {
            return this.metricsById.get(id);
        }

        public void increaseNumberOfProcessedQualityGate() {
            ++this.nbOfQualityGates;
        }

        public int getNbOfQualityGates() {
            return this.nbOfQualityGates;
        }

        public void addRemovedConditions(int removedConditions) {
            this.nbOfRemovedConditions += removedConditions;
        }

        public int getNbOfRemovedConditions() {
            return this.nbOfRemovedConditions;
        }

        public void addUpdatedConditions(int updatedConditions) {
            this.nbOfUpdatedConditions += updatedConditions;
        }

        public int getNbOfUpdatedConditions() {
            return this.nbOfUpdatedConditions;
        }
    }

    private static class Metric {
        private final int id;
        private final String key;
        private final String type;
        private final int direction;

        public Metric(int id, String key, String type, int direction) {
            this.id = id;
            this.key = key;
            this.type = type;
            this.direction = direction;
        }

        public int getId() {
            return this.id;
        }

        public String getKey() {
            return this.key;
        }

        public String getType() {
            return this.type;
        }

        public int getDirection() {
            return this.direction;
        }
    }

    private static class QualityGateCondition {
        private final int id;
        private final int metricId;
        private final String operator;
        private final String error;
        private final String warning;
        private final Integer period;
        private boolean toBeDeleted = false;

        public QualityGateCondition(int id, int metricId, String operator, @Nullable String error, @Nullable String warning, @Nullable Integer period) {
            this.id = id;
            this.metricId = metricId;
            this.operator = operator;
            this.error = error;
            this.warning = warning;
            this.period = period;
        }

        public int getId() {
            return this.id;
        }

        public int getMetricId() {
            return this.metricId;
        }

        public String getOperator() {
            return this.operator;
        }

        @CheckForNull
        public String getError() {
            return this.error;
        }

        @CheckForNull
        public String getWarning() {
            return this.warning;
        }

        public boolean hasLeakPeriod() {
            return this.period != null && this.period == 1;
        }

        public void setToBeDeleted() {
            this.toBeDeleted = true;
        }

        public boolean isToBeDeleted() {
            return this.toBeDeleted;
        }
    }
}

