/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v79;

import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.SupportsBlueGreen;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

@SupportsBlueGreen
public class TruncateEnvAndSystemVarsFromScannerContext
extends DataChange {
    public TruncateEnvAndSystemVarsFromScannerContext(Database db) {
        super(db);
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select task_uuid, context_data from ce_scanner_context sc");
        massUpdate.update("update ce_scanner_context set context_data = ? where task_uuid = ?");
        massUpdate.rowPluralName("truncate scanner context content");
        massUpdate.execute(TruncateEnvAndSystemVarsFromScannerContext::truncateScannerContext);
    }

    private static boolean truncateScannerContext(Select.Row row, SqlStatement update) throws SQLException {
        String taskUuid = row.getString(1);
        byte[] bytes = row.getBytes(2);
        String reportContent = new String(bytes, StandardCharsets.UTF_8);
        int startIndex = reportContent.indexOf("SonarQube plugins:");
        if (startIndex != -1) {
            reportContent = reportContent.substring(startIndex);
        }
        update.setBytes(1, reportContent.getBytes(StandardCharsets.UTF_8));
        update.setString(2, taskUuid);
        return true;
    }
}

