/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.analysis;

import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.config.Configuration;
import org.sonar.api.config.Settings;
import org.sonar.api.config.internal.ConfigurationBridge;
import org.sonar.ce.task.projectanalysis.analysis.Branch;
import org.sonar.db.DbClient;
import org.sonar.db.component.BranchType;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.setting.ChildSettings;

@ComputeEngineSide
public class ProjectConfigurationFactory {
    private final Settings globalSettings;
    private final DbClient dbClient;

    public ProjectConfigurationFactory(Settings globalSettings, DbClient dbClient) {
        this.globalSettings = globalSettings;
        this.dbClient = dbClient;
    }

    public Configuration newProjectConfiguration(String projectKey, Branch branch) {
        ChildSettings projectSettings = new ChildSettings(this.globalSettings);
        this.addSettings((Settings)projectSettings, projectKey);
        if (branch.getType() == BranchType.PULL_REQUEST) {
            this.addSettings((Settings)projectSettings, ComponentDto.generatePullRequestKey((String)projectKey, (String)branch.getPullRequestKey()));
        } else {
            this.addSettings((Settings)projectSettings, ComponentDto.generateBranchKey((String)projectKey, (String)branch.getName()));
        }
        return new ConfigurationBridge((Settings)projectSettings);
    }

    private void addSettings(Settings settings, String componentDbKey) {
        this.dbClient.propertiesDao().selectProjectProperties(componentDbKey).forEach(property -> settings.setProperty(property.getKey(), property.getValue()));
    }
}

