/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.api.measurecomputer;

import com.google.common.base.Preconditions;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.sonar.ce.task.projectanalysis.measure.Measure;

@Immutable
public class MeasureImpl
implements org.sonar.api.ce.measure.Measure {
    private static final EnumSet<Measure.ValueType> ALLOWED_VALUE_TYPES = EnumSet.of(Measure.ValueType.INT, Measure.ValueType.LONG, Measure.ValueType.DOUBLE, Measure.ValueType.STRING, Measure.ValueType.BOOLEAN);
    private final Measure measure;

    public MeasureImpl(Measure measure) {
        this.measure = Objects.requireNonNull(measure, "Measure couldn't be null");
        Preconditions.checkState((boolean)ALLOWED_VALUE_TYPES.contains((Object)measure.getValueType()), (String)"Only following types are allowed %s", (Object[])new Object[]{ALLOWED_VALUE_TYPES});
    }

    public int getIntValue() {
        this.checkValueType(Measure.ValueType.INT);
        return this.measure.getIntValue();
    }

    public long getLongValue() {
        this.checkValueType(Measure.ValueType.LONG);
        return this.measure.getLongValue();
    }

    public double getDoubleValue() {
        this.checkValueType(Measure.ValueType.DOUBLE);
        return this.measure.getDoubleValue();
    }

    public String getStringValue() {
        this.checkValueType(Measure.ValueType.STRING);
        return this.measure.getStringValue();
    }

    public boolean getBooleanValue() {
        this.checkValueType(Measure.ValueType.BOOLEAN);
        return this.measure.getBooleanValue();
    }

    private void checkValueType(Measure.ValueType expected) {
        if (this.measure.getValueType() != expected) {
            throw new IllegalStateException(String.format("Value can not be converted to %s because current value type is a %s", new Object[]{expected.toString().toLowerCase(Locale.US), this.measure.getValueType()}));
        }
    }

    public String toString() {
        return "MeasureImpl{measure=" + this.measure + '}';
    }
}

