/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.api.posttask;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.ce.posttask.QualityGate;

@Immutable
class ConditionImpl
implements QualityGate.Condition {
    private final QualityGate.EvaluationStatus status;
    private final String metricKey;
    private final QualityGate.Operator operator;
    private final String errorThreshold;
    private final boolean onLeakPeriod;
    @CheckForNull
    private final String value;

    private ConditionImpl(Builder builder) {
        Objects.requireNonNull(builder.status, "status can not be null");
        Objects.requireNonNull(builder.metricKey, "metricKey can not be null");
        Objects.requireNonNull(builder.operator, "operator can not be null");
        Objects.requireNonNull(builder.errorThreshold, "errorThreshold can not be null");
        ConditionImpl.verifyValue(builder);
        this.status = builder.status;
        this.metricKey = builder.metricKey;
        this.operator = builder.operator;
        this.errorThreshold = builder.errorThreshold;
        this.onLeakPeriod = builder.metricKey.startsWith("new_");
        this.value = builder.value;
    }

    private static void verifyValue(Builder builder) {
        if (builder.status == QualityGate.EvaluationStatus.NO_VALUE) {
            Preconditions.checkArgument((builder.value == null ? 1 : 0) != 0, (String)"value must be null when status is %s", (Object[])new Object[]{QualityGate.EvaluationStatus.NO_VALUE});
        } else {
            Preconditions.checkArgument((builder.value != null ? 1 : 0) != 0, (String)"value can not be null when status is not %s", (Object[])new Object[]{QualityGate.EvaluationStatus.NO_VALUE});
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public QualityGate.EvaluationStatus getStatus() {
        return this.status;
    }

    public String getMetricKey() {
        return this.metricKey;
    }

    public QualityGate.Operator getOperator() {
        return this.operator;
    }

    public String getErrorThreshold() {
        return this.errorThreshold;
    }

    @Deprecated
    public String getWarningThreshold() {
        return null;
    }

    @Deprecated
    public boolean isOnLeakPeriod() {
        return this.onLeakPeriod;
    }

    public String getValue() {
        Preconditions.checkState((this.status != QualityGate.EvaluationStatus.NO_VALUE ? 1 : 0) != 0, (String)"There is no value when status is %s", (Object[])new Object[]{QualityGate.EvaluationStatus.NO_VALUE});
        return this.value;
    }

    public String toString() {
        return "ConditionImpl{status=" + this.status + ", metricKey='" + this.metricKey + '\'' + ", operator=" + this.operator + ", errorThreshold='" + this.errorThreshold + '\'' + ", value='" + this.value + '\'' + '}';
    }

    public static class Builder {
        private String metricKey;
        private QualityGate.Operator operator;
        private String errorThreshold;
        @CheckForNull
        private String value;
        private QualityGate.EvaluationStatus status;

        private Builder() {
        }

        public Builder setMetricKey(String metricKey) {
            this.metricKey = metricKey;
            return this;
        }

        public Builder setOperator(QualityGate.Operator operator) {
            this.operator = operator;
            return this;
        }

        public Builder setErrorThreshold(String errorThreshold) {
            this.errorThreshold = errorThreshold;
            return this;
        }

        @Deprecated
        public Builder setWarningThreshold(String warningThreshold) {
            return this;
        }

        @Deprecated
        public Builder setOnLeakPeriod(boolean onLeakPeriod) {
            return this;
        }

        public Builder setValue(String value) {
            this.value = value;
            return this;
        }

        public Builder setStatus(QualityGate.EvaluationStatus status) {
            this.status = status;
            return this;
        }

        public ConditionImpl build() {
            return new ConditionImpl(this);
        }
    }
}

