/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.api.posttask;

import java.util.Set;
import java.util.function.Function;
import org.sonar.api.ce.posttask.QualityGate;
import org.sonar.api.measures.Metric;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.qualitygate.Condition;
import org.sonar.server.qualitygate.EvaluatedCondition;
import org.sonar.server.qualitygate.EvaluatedQualityGate;

public class QGToEvaluatedQG
implements Function<QualityGate, EvaluatedQualityGate> {
    public static final QGToEvaluatedQG INSTANCE = new QGToEvaluatedQG();

    private QGToEvaluatedQG() {
    }

    @Override
    public EvaluatedQualityGate apply(QualityGate qg) {
        EvaluatedQualityGate.Builder builder = EvaluatedQualityGate.newBuilder();
        Set conditions = (Set)qg.getConditions().stream().map(q -> {
            Condition condition = new Condition(q.getMetricKey(), Condition.Operator.valueOf((String)q.getOperator().name()), q.getErrorThreshold());
            builder.addEvaluatedCondition(condition, EvaluatedCondition.EvaluationStatus.valueOf((String)q.getStatus().name()), q.getStatus() == QualityGate.EvaluationStatus.NO_VALUE ? null : q.getValue());
            return condition;
        }).collect(MoreCollectors.toSet());
        return builder.setQualityGate(new org.sonar.server.qualitygate.QualityGate(qg.getId(), qg.getName(), conditions)).setStatus(Metric.Level.valueOf((String)qg.getStatus().name())).build();
    }
}

