/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.component;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.StringUtils;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.FileAttributes;
import org.sonar.ce.task.projectanalysis.component.ProjectAttributes;
import org.sonar.ce.task.projectanalysis.component.ProjectViewAttributes;
import org.sonar.ce.task.projectanalysis.component.ReportAttributes;
import org.sonar.ce.task.projectanalysis.component.SubViewAttributes;
import org.sonar.ce.task.projectanalysis.component.ViewAttributes;

@Immutable
public class ComponentImpl
implements Component {
    private final Component.Type type;
    private final Component.Status status;
    private final String name;
    private final String shortName;
    private final String dbKey;
    private final String key;
    private final String uuid;
    @CheckForNull
    private final String description;
    private final List<Component> children;
    @CheckForNull
    private final ProjectAttributes projectAttributes;
    private final ReportAttributes reportAttributes;
    @CheckForNull
    private final FileAttributes fileAttributes;

    private ComponentImpl(Builder builder) {
        this.type = builder.type;
        this.status = builder.status;
        this.dbKey = builder.dbKey;
        this.key = (String)MoreObjects.firstNonNull((Object)builder.key, (Object)builder.dbKey);
        this.name = builder.name;
        this.shortName = (String)MoreObjects.firstNonNull((Object)builder.shortName, (Object)builder.name);
        this.description = builder.description;
        this.uuid = builder.uuid;
        this.projectAttributes = builder.projectAttributes;
        this.reportAttributes = builder.reportAttributes;
        this.fileAttributes = builder.fileAttributes;
        this.children = ImmutableList.copyOf((Collection)builder.children);
    }

    @Override
    public Component.Type getType() {
        return this.type;
    }

    @Override
    public Component.Status getStatus() {
        return this.status;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public String getDbKey() {
        return this.dbKey;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    @CheckForNull
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<Component> getChildren() {
        return this.children;
    }

    @Override
    public ProjectAttributes getProjectAttributes() {
        Preconditions.checkState((this.type == Component.Type.PROJECT ? 1 : 0) != 0, (Object)"Only component of type PROJECT have a ProjectAttributes object");
        return this.projectAttributes;
    }

    @Override
    public ReportAttributes getReportAttributes() {
        return this.reportAttributes;
    }

    @Override
    public FileAttributes getFileAttributes() {
        Preconditions.checkState((this.type == Component.Type.FILE ? 1 : 0) != 0, (Object)"Only component of type FILE have a FileAttributes object");
        return this.fileAttributes;
    }

    @Override
    public ProjectViewAttributes getProjectViewAttributes() {
        throw new IllegalStateException("Only component of type PROJECT_VIEW have a ProjectViewAttributes object");
    }

    @Override
    public SubViewAttributes getSubViewAttributes() {
        throw new IllegalStateException("Only component of type SUBVIEW have a SubViewAttributes object");
    }

    @Override
    public ViewAttributes getViewAttributes() {
        throw new IllegalStateException("Only component of type VIEW have a ViewAttributes object");
    }

    public static Builder builder(Component.Type type) {
        return new Builder(type);
    }

    public String toString() {
        return "ComponentImpl{type=" + (Object)((Object)this.type) + ", status=" + (Object)((Object)this.status) + ", name='" + this.name + '\'' + ", dbKey='" + this.dbKey + '\'' + ", key='" + this.key + '\'' + ", uuid='" + this.uuid + '\'' + ", description='" + this.description + '\'' + ", children=" + this.children + ", projectAttributes=" + this.projectAttributes + ", reportAttributes=" + this.reportAttributes + ", fileAttributes=" + this.fileAttributes + '}';
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentImpl component = (ComponentImpl)o;
        return this.uuid.equals(component.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public static final class Builder {
        private static final String DB_KEY_CANNOT_BE_NULL = "DB key can't be null";
        private static final String KEY_CANNOT_BE_NULL = "Key can't be null";
        private static final String UUID_CANNOT_BE_NULL = "uuid can't be null";
        private static final String REPORT_ATTRIBUTES_CANNOT_BE_NULL = "reportAttributes can't be null";
        private static final String NAME_CANNOT_BE_NULL = "name can't be null";
        private static final String STATUS_CANNOT_BE_NULL = "status can't be null";
        private final Component.Type type;
        private Component.Status status;
        private ProjectAttributes projectAttributes;
        private ReportAttributes reportAttributes;
        private String uuid;
        private String dbKey;
        private String key;
        private String name;
        private String shortName;
        private String description;
        private FileAttributes fileAttributes;
        private final List<Component> children = new ArrayList<Component>();

        private Builder(Component.Type type) {
            this.type = Objects.requireNonNull(type, "type can't be null");
        }

        public Builder setUuid(String s) {
            this.uuid = Objects.requireNonNull(s, UUID_CANNOT_BE_NULL);
            return this;
        }

        @CheckForNull
        public String getUuid() {
            return this.uuid;
        }

        public Builder setStatus(Component.Status status) {
            this.status = Objects.requireNonNull(status, STATUS_CANNOT_BE_NULL);
            return this;
        }

        public Builder setDbKey(String s) {
            this.dbKey = Objects.requireNonNull(s, DB_KEY_CANNOT_BE_NULL);
            return this;
        }

        public Builder setKey(String key) {
            this.key = Objects.requireNonNull(key, KEY_CANNOT_BE_NULL);
            return this;
        }

        public Builder setName(String name) {
            this.name = StringUtils.abbreviate((String)Objects.requireNonNull(name, NAME_CANNOT_BE_NULL), (int)500);
            return this;
        }

        public Builder setShortName(String shortName) {
            this.shortName = StringUtils.abbreviate((String)Objects.requireNonNull(shortName, NAME_CANNOT_BE_NULL), (int)500);
            return this;
        }

        public Builder setDescription(@Nullable String description) {
            this.description = StringUtils.abbreviate((String)StringUtils.trimToNull((String)description), (int)2000);
            return this;
        }

        public Builder setProjectAttributes(ProjectAttributes projectAttributes) {
            this.checkProjectAttributes(projectAttributes);
            this.projectAttributes = projectAttributes;
            return this;
        }

        public Builder setReportAttributes(ReportAttributes reportAttributes) {
            this.reportAttributes = Objects.requireNonNull(reportAttributes, REPORT_ATTRIBUTES_CANNOT_BE_NULL);
            return this;
        }

        public Builder setFileAttributes(@Nullable FileAttributes fileAttributes) {
            this.fileAttributes = fileAttributes;
            return this;
        }

        public Builder addChildren(List<Component> components) {
            for (Component component : components) {
                Preconditions.checkArgument((boolean)component.getType().isReportType());
            }
            this.children.addAll(components);
            return this;
        }

        public ComponentImpl build() {
            Objects.requireNonNull(this.reportAttributes, REPORT_ATTRIBUTES_CANNOT_BE_NULL);
            Objects.requireNonNull(this.uuid, UUID_CANNOT_BE_NULL);
            Objects.requireNonNull(this.dbKey, DB_KEY_CANNOT_BE_NULL);
            Objects.requireNonNull(this.name, NAME_CANNOT_BE_NULL);
            Objects.requireNonNull(this.status, STATUS_CANNOT_BE_NULL);
            this.checkProjectAttributes(this.projectAttributes);
            return new ComponentImpl(this);
        }

        private void checkProjectAttributes(@Nullable ProjectAttributes projectAttributes) {
            Preconditions.checkArgument((boolean)(this.type != Component.Type.PROJECT ^ projectAttributes != null), (Object)"ProjectAttributes must and can only be set for type PROJECT");
        }
    }
}

