/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.component;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.ce.task.projectanalysis.analysis.Branch;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ComponentImpl;
import org.sonar.ce.task.projectanalysis.component.ComponentKeyGenerator;
import org.sonar.ce.task.projectanalysis.component.FileAttributes;
import org.sonar.ce.task.projectanalysis.component.ProjectAttributes;
import org.sonar.ce.task.projectanalysis.component.ReportAttributes;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.server.project.Project;

public class ComponentTreeBuilder {
    private final ComponentKeyGenerator keyGenerator;
    private final ComponentKeyGenerator publicKeyGenerator;
    private final Function<String, String> uuidSupplier;
    private final Function<Integer, ScannerReport.Component> scannerComponentSupplier;
    private final Project project;
    private final Branch branch;
    @Nullable
    private final ProjectAttributes projectAttributes;
    private ScannerReport.Component rootComponent;
    private String scmBasePath;

    public ComponentTreeBuilder(ComponentKeyGenerator keyGenerator, ComponentKeyGenerator publicKeyGenerator, Function<String, String> uuidSupplier, Function<Integer, ScannerReport.Component> scannerComponentSupplier, Project project, Branch branch, ProjectAttributes projectAttributes) {
        this.keyGenerator = keyGenerator;
        this.publicKeyGenerator = publicKeyGenerator;
        this.uuidSupplier = uuidSupplier;
        this.scannerComponentSupplier = scannerComponentSupplier;
        this.project = project;
        this.branch = branch;
        this.projectAttributes = Objects.requireNonNull(projectAttributes, "projectAttributes can't be null");
    }

    public Component buildProject(ScannerReport.Component project, String scmBasePath) {
        this.rootComponent = project;
        this.scmBasePath = StringUtils.trimToNull((String)scmBasePath);
        Node root = this.createProjectHierarchy(project);
        return this.buildComponent(root, "", "");
    }

    private Node createProjectHierarchy(ScannerReport.Component rootComponent) {
        Preconditions.checkArgument((rootComponent.getType() == ScannerReport.Component.ComponentType.PROJECT ? 1 : 0) != 0, (Object)"Expected root component of type 'PROJECT'");
        LinkedList queue = new LinkedList();
        rootComponent.getChildRefList().stream().map(this.scannerComponentSupplier).forEach(queue::addLast);
        Node root = new Node();
        root.reportComponent = rootComponent;
        block3: while (!queue.isEmpty()) {
            ScannerReport.Component component = (ScannerReport.Component)queue.removeFirst();
            switch (component.getType()) {
                case FILE: {
                    ComponentTreeBuilder.addFile(root, component);
                    continue block3;
                }
            }
            throw new IllegalArgumentException(String.format("Unsupported component type '%s'", component.getType()));
        }
        return root;
    }

    private static void addFile(Node root, ScannerReport.Component file) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)file.getProjectRelativePath()) ? 1 : 0) != 0, (Object)("Files should have a project relative path: " + file));
        String[] split = StringUtils.split((String)file.getProjectRelativePath(), (char)'/');
        Node currentNode = root;
        for (int i = 0; i < split.length; ++i) {
            currentNode = currentNode.children().computeIfAbsent(split[i], k -> new Node());
        }
        currentNode.reportComponent = file;
    }

    private Component buildComponent(Node node, String currentPath, String parentPath) {
        List<Component> childComponents = this.buildChildren(node, currentPath);
        ScannerReport.Component component = node.reportComponent();
        if (component != null) {
            if (component.getType() == ScannerReport.Component.ComponentType.FILE) {
                return this.buildFile(component);
            }
            if (component.getType() == ScannerReport.Component.ComponentType.PROJECT) {
                return this.buildProject(childComponents);
            }
        }
        return this.buildDirectory(parentPath, currentPath, childComponents);
    }

    private List<Component> buildChildren(Node node, String currentPath) {
        ArrayList<Component> children = new ArrayList<Component>();
        for (Map.Entry e : node.children().entrySet()) {
            String path = ComponentTreeBuilder.buildPath(currentPath, (String)e.getKey());
            Node childNode = (Node)e.getValue();
            while (childNode.children().size() == 1 && ((Node)childNode.children().values().iterator().next()).children().size() > 0) {
                Map.Entry childEntry = childNode.children().entrySet().iterator().next();
                path = ComponentTreeBuilder.buildPath(path, (String)childEntry.getKey());
                childNode = (Node)childEntry.getValue();
            }
            children.add(this.buildComponent(childNode, path, currentPath));
        }
        return children;
    }

    private static String buildPath(String currentPath, String file) {
        if (currentPath.isEmpty()) {
            return file;
        }
        return currentPath + "/" + file;
    }

    private Component buildProject(List<Component> children) {
        String projectKey = this.keyGenerator.generateKey(this.rootComponent.getKey(), null);
        String uuid = this.uuidSupplier.apply(projectKey);
        String projectPublicKey = this.publicKeyGenerator.generateKey(this.rootComponent.getKey(), null);
        ComponentImpl.Builder builder = ComponentImpl.builder(Component.Type.PROJECT).setUuid(uuid).setDbKey(projectKey).setKey(projectPublicKey).setStatus(ComponentTreeBuilder.convertStatus(this.rootComponent.getStatus())).setProjectAttributes(this.projectAttributes).setReportAttributes(ComponentTreeBuilder.createAttributesBuilder(this.rootComponent.getRef(), this.rootComponent.getProjectRelativePath(), this.scmBasePath).build()).addChildren(children);
        this.setNameAndDescription(this.rootComponent, builder);
        return builder.build();
    }

    private ComponentImpl buildFile(ScannerReport.Component component) {
        String key = this.keyGenerator.generateKey(this.rootComponent.getKey(), component.getProjectRelativePath());
        String publicKey = this.publicKeyGenerator.generateKey(this.rootComponent.getKey(), component.getProjectRelativePath());
        return ComponentImpl.builder(Component.Type.FILE).setUuid(this.uuidSupplier.apply(key)).setDbKey(key).setKey(publicKey).setName(component.getProjectRelativePath()).setShortName(FilenameUtils.getName((String)component.getProjectRelativePath())).setStatus(ComponentTreeBuilder.convertStatus(component.getStatus())).setDescription(StringUtils.trimToNull((String)component.getDescription())).setReportAttributes(ComponentTreeBuilder.createAttributesBuilder(component.getRef(), component.getProjectRelativePath(), this.scmBasePath).build()).setFileAttributes(ComponentTreeBuilder.createFileAttributes(component)).build();
    }

    private ComponentImpl buildDirectory(String parentPath, String path, List<Component> children) {
        String key = this.keyGenerator.generateKey(this.rootComponent.getKey(), path);
        String publicKey = this.publicKeyGenerator.generateKey(this.rootComponent.getKey(), path);
        return ComponentImpl.builder(Component.Type.DIRECTORY).setUuid(this.uuidSupplier.apply(key)).setDbKey(key).setKey(publicKey).setName(path).setShortName(StringUtils.removeStart((String)StringUtils.removeStart((String)path, (String)parentPath), (String)"/")).setStatus(ComponentTreeBuilder.convertStatus(ScannerReport.Component.FileStatus.UNAVAILABLE)).setReportAttributes(ComponentTreeBuilder.createAttributesBuilder(null, path, this.scmBasePath).build()).addChildren(children).build();
    }

    public Component buildChangedComponentTreeRoot(Component project) {
        return ComponentTreeBuilder.buildChangedComponentTree(project);
    }

    private static ComponentImpl.Builder changedComponentBuilder(Component component) {
        return ComponentImpl.builder(component.getType()).setUuid(component.getUuid()).setDbKey(component.getDbKey()).setKey(component.getKey()).setStatus(component.getStatus()).setReportAttributes(component.getReportAttributes()).setName(component.getName()).setShortName(component.getShortName()).setDescription(component.getDescription());
    }

    @Nullable
    private static Component buildChangedComponentTree(Component component) {
        switch (component.getType()) {
            case PROJECT: {
                return ComponentTreeBuilder.buildChangedProject(component);
            }
            case DIRECTORY: {
                return ComponentTreeBuilder.buildChangedIntermediate(component);
            }
            case FILE: {
                return ComponentTreeBuilder.buildChangedFile(component);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported component type '%s'", new Object[]{component.getType()}));
    }

    private static Component buildChangedProject(Component component) {
        return ComponentTreeBuilder.changedComponentBuilder(component).setProjectAttributes(new ProjectAttributes(component.getProjectAttributes())).addChildren(ComponentTreeBuilder.buildChangedComponentChildren(component)).build();
    }

    @Nullable
    private static Component buildChangedIntermediate(Component component) {
        List<Component> children = ComponentTreeBuilder.buildChangedComponentChildren(component);
        if (children.isEmpty()) {
            return null;
        }
        return ComponentTreeBuilder.changedComponentBuilder(component).addChildren(children).build();
    }

    @Nullable
    private static Component buildChangedFile(Component component) {
        if (component.getStatus() == Component.Status.SAME) {
            return null;
        }
        return ComponentTreeBuilder.changedComponentBuilder(component).setFileAttributes(component.getFileAttributes()).build();
    }

    private static List<Component> buildChangedComponentChildren(Component component) {
        return (List)component.getChildren().stream().map(ComponentTreeBuilder::buildChangedComponentTree).filter(Objects::nonNull).collect(MoreCollectors.toList());
    }

    private void setNameAndDescription(ScannerReport.Component component, ComponentImpl.Builder builder) {
        if (this.branch.isMain()) {
            builder.setName(this.nameOfProject(component)).setDescription(component.getDescription());
        } else {
            builder.setName(this.project.getName()).setDescription(this.project.getDescription());
        }
    }

    private static Component.Status convertStatus(ScannerReport.Component.FileStatus status) {
        switch (status) {
            case ADDED: {
                return Component.Status.ADDED;
            }
            case SAME: {
                return Component.Status.SAME;
            }
            case CHANGED: {
                return Component.Status.CHANGED;
            }
            case UNAVAILABLE: {
                return Component.Status.UNAVAILABLE;
            }
        }
        throw new IllegalArgumentException("Unsupported ComponentType value " + status);
    }

    private String nameOfProject(ScannerReport.Component component) {
        String name = StringUtils.trimToNull((String)component.getName());
        if (name != null) {
            return name;
        }
        return this.project.getName();
    }

    private static ReportAttributes.Builder createAttributesBuilder(@Nullable Integer ref, String path, @Nullable String scmBasePath) {
        return ReportAttributes.newBuilder(ref).setScmPath(ComponentTreeBuilder.computeScmPath(scmBasePath, path));
    }

    @CheckForNull
    private static String computeScmPath(@Nullable String scmBasePath, String scmRelativePath) {
        if (scmRelativePath.isEmpty()) {
            return scmBasePath;
        }
        if (scmBasePath == null) {
            return scmRelativePath;
        }
        return scmBasePath + '/' + scmRelativePath;
    }

    private static FileAttributes createFileAttributes(ScannerReport.Component component) {
        Preconditions.checkArgument((component.getType() == ScannerReport.Component.ComponentType.FILE ? 1 : 0) != 0);
        Preconditions.checkArgument((component.getLines() > 0 ? 1 : 0) != 0, (String)"File '%s' has no line", (Object[])new Object[]{component.getProjectRelativePath()});
        return new FileAttributes(component.getIsTest(), StringUtils.trimToNull((String)component.getLanguage()), component.getLines());
    }

    private static class Node {
        private final Map<String, Node> children = new LinkedHashMap<String, Node>();
        private ScannerReport.Component reportComponent;

        private Node() {
        }

        private Map<String, Node> children() {
            return this.children;
        }

        @CheckForNull
        private ScannerReport.Component reportComponent() {
            return this.reportComponent;
        }
    }
}

