/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.component;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.ce.task.projectanalysis.component.Component;

@Immutable
public class CrawlerDepthLimit {
    private static final String UNSUPPORTED_TYPE_UOE_MSG = "Specified type is neither a report type nor a views type";
    public static final CrawlerDepthLimit PROJECT = new CrawlerDepthLimit(Component.Type.PROJECT, null);
    public static final CrawlerDepthLimit DIRECTORY = new CrawlerDepthLimit(Component.Type.DIRECTORY, null);
    public static final CrawlerDepthLimit FILE = new CrawlerDepthLimit(Component.Type.FILE, null);
    public static final CrawlerDepthLimit VIEW = new CrawlerDepthLimit(null, Component.Type.VIEW);
    public static final CrawlerDepthLimit SUBVIEW = new CrawlerDepthLimit(null, Component.Type.SUBVIEW);
    public static final CrawlerDepthLimit PROJECT_VIEW = new CrawlerDepthLimit(null, Component.Type.PROJECT_VIEW);
    public static final CrawlerDepthLimit LEAVES = new CrawlerDepthLimit(Component.Type.FILE, Component.Type.PROJECT_VIEW);
    public static final CrawlerDepthLimit ROOTS = new CrawlerDepthLimit(Component.Type.PROJECT, Component.Type.VIEW);
    @CheckForNull
    private final Component.Type reportMaxDepth;
    @CheckForNull
    private final Component.Type viewsMaxDepth;

    private CrawlerDepthLimit(@Nullable Component.Type reportMaxDepth, @Nullable Component.Type viewsMaxDepth) {
        Preconditions.checkArgument((reportMaxDepth != null || viewsMaxDepth != null ? 1 : 0) != 0, (Object)"At least one type must be non null");
        Preconditions.checkArgument((reportMaxDepth == null || reportMaxDepth.isReportType() ? 1 : 0) != 0);
        Preconditions.checkArgument((viewsMaxDepth == null || viewsMaxDepth.isViewsType() ? 1 : 0) != 0);
        this.reportMaxDepth = reportMaxDepth;
        this.viewsMaxDepth = viewsMaxDepth;
    }

    public static Builder reportMaxDepth(Component.Type reportMaxDepth) {
        return new Builder(reportMaxDepth);
    }

    public boolean isDeeperThan(Component.Type otherType) {
        if (otherType.isViewsType()) {
            return this.viewsMaxDepth != null && this.viewsMaxDepth.isDeeperThan(otherType);
        }
        if (otherType.isReportType()) {
            return this.reportMaxDepth != null && this.reportMaxDepth.isDeeperThan(otherType);
        }
        throw new UnsupportedOperationException(UNSUPPORTED_TYPE_UOE_MSG);
    }

    public boolean isHigherThan(Component.Type otherType) {
        if (otherType.isViewsType()) {
            return this.viewsMaxDepth != null && this.viewsMaxDepth.isHigherThan(otherType);
        }
        if (otherType.isReportType()) {
            return this.reportMaxDepth != null && this.reportMaxDepth.isHigherThan(otherType);
        }
        throw new UnsupportedOperationException(UNSUPPORTED_TYPE_UOE_MSG);
    }

    public boolean isSameAs(Component.Type otherType) {
        if (otherType.isViewsType()) {
            return otherType == this.viewsMaxDepth;
        }
        if (otherType.isReportType()) {
            return otherType == this.reportMaxDepth;
        }
        throw new UnsupportedOperationException(UNSUPPORTED_TYPE_UOE_MSG);
    }

    public static class Builder {
        private final Component.Type reportMaxDepth;

        public Builder(Component.Type reportMaxDepth) {
            Preconditions.checkArgument((boolean)reportMaxDepth.isReportType(), (Object)"A Report max depth must be a report type");
            this.reportMaxDepth = reportMaxDepth;
        }

        public CrawlerDepthLimit withViewsMaxDepth(Component.Type viewsMaxDepth) {
            Preconditions.checkArgument((boolean)viewsMaxDepth.isViewsType(), (Object)"A Views max depth must be a views type");
            return new CrawlerDepthLimit(this.reportMaxDepth, viewsMaxDepth);
        }
    }
}

