/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.component;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckForNull;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.BranchDto;
import org.sonar.db.component.ComponentDto;

public class MergeAndTargetBranchComponentUuids {
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final DbClient dbClient;
    private Map<String, String> mergeBranchComponentsUuidsByKey;
    private Map<String, String> targetBranchComponentsUuidsByKey;
    private String mergeBranchName;
    private boolean hasMergeBranchAnalysis;
    private boolean hasTargetBranchAnalysis;
    @CheckForNull
    private String targetBranchUuid;

    public MergeAndTargetBranchComponentUuids(AnalysisMetadataHolder analysisMetadataHolder, DbClient dbClient) {
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.dbClient = dbClient;
    }

    private void lazyInit() {
        if (this.mergeBranchComponentsUuidsByKey == null) {
            String mergeBranchUuid = this.analysisMetadataHolder.getBranch().getMergeBranchUuid();
            this.mergeBranchComponentsUuidsByKey = new HashMap<String, String>();
            this.targetBranchComponentsUuidsByKey = new HashMap<String, String>();
            try (DbSession dbSession = this.dbClient.openSession(false);){
                Optional opt = this.dbClient.branchDao().selectByUuid(dbSession, mergeBranchUuid);
                Preconditions.checkState((boolean)opt.isPresent(), (String)"Merge branch '%s' does not exist", (Object[])new Object[]{mergeBranchUuid});
                this.mergeBranchName = ((BranchDto)opt.get()).getKey();
                this.initForMergeBranch(mergeBranchUuid, dbSession);
                if (this.analysisMetadataHolder.isSLBorPR()) {
                    this.initForTargetBranch(mergeBranchUuid, dbSession);
                } else {
                    this.hasTargetBranchAnalysis = false;
                }
            }
        }
    }

    private void initForTargetBranch(String mergeBranchUuid, DbSession dbSession) {
        Optional branchDtoOpt = this.dbClient.branchDao().selectByBranchKey(dbSession, this.analysisMetadataHolder.getProject().getUuid(), this.analysisMetadataHolder.getBranch().getTargetBranchName());
        this.targetBranchUuid = branchDtoOpt.map(BranchDto::getUuid).orElse(null);
        boolean bl = this.hasTargetBranchAnalysis = this.targetBranchUuid != null && this.dbClient.snapshotDao().selectLastAnalysisByRootComponentUuid(dbSession, this.targetBranchUuid).isPresent();
        if (this.hasTargetBranchAnalysis && !this.targetBranchUuid.equals(mergeBranchUuid)) {
            List targetComponents = this.dbClient.componentDao().selectByProjectUuid(this.targetBranchUuid, dbSession);
            for (ComponentDto dto : targetComponents) {
                this.targetBranchComponentsUuidsByKey.put(dto.getKey(), dto.uuid());
            }
        }
    }

    private void initForMergeBranch(String mergeBranchUuid, DbSession dbSession) {
        this.hasMergeBranchAnalysis = this.dbClient.snapshotDao().selectLastAnalysisByRootComponentUuid(dbSession, mergeBranchUuid).isPresent();
        if (this.hasMergeBranchAnalysis) {
            List components = this.dbClient.componentDao().selectByProjectUuid(mergeBranchUuid, dbSession);
            for (ComponentDto dto : components) {
                this.mergeBranchComponentsUuidsByKey.put(dto.getKey(), dto.uuid());
            }
        }
    }

    public boolean hasMergeBranchAnalysis() {
        this.lazyInit();
        return this.hasMergeBranchAnalysis;
    }

    public boolean hasTargetBranchAnalysis() {
        this.lazyInit();
        return this.hasTargetBranchAnalysis;
    }

    public String getMergeBranchName() {
        this.lazyInit();
        return this.mergeBranchName;
    }

    public boolean areTargetAndMergeBranchesDifferent() {
        this.lazyInit();
        return this.targetBranchUuid == null || !this.analysisMetadataHolder.getBranch().getMergeBranchUuid().equals(this.targetBranchUuid);
    }

    @CheckForNull
    public String getMergeBranchComponentUuid(String dbKey) {
        this.lazyInit();
        String cleanComponentKey = ComponentDto.removeBranchAndPullRequestFromKey((String)dbKey);
        return this.mergeBranchComponentsUuidsByKey.get(cleanComponentKey);
    }

    @CheckForNull
    public String getTargetBranchComponentUuid(String dbKey) {
        this.lazyInit();
        String cleanComponentKey = ComponentDto.removeBranchAndPullRequestFromKey((String)dbKey);
        return this.targetBranchComponentsUuidsByKey.get(cleanComponentKey);
    }
}

