/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.component;

import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ProjectViewAttributes {
    private final String projectUuid;
    private final String originalKey;
    @CheckForNull
    private final Long analysisDate;
    private final String branchName;

    public ProjectViewAttributes(String projectUuid, String originalKey, @Nullable Long analysisDate, @Nullable String branchName) {
        this.projectUuid = Objects.requireNonNull(projectUuid, "projectUuid can't be null");
        this.originalKey = Objects.requireNonNull(originalKey, "projectKey can't be null");
        this.analysisDate = analysisDate;
        this.branchName = branchName;
    }

    public String getProjectUuid() {
        return this.projectUuid;
    }

    @CheckForNull
    public Long getAnalysisDate() {
        return this.analysisDate;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public String getOriginalKey() {
        return this.originalKey;
    }

    public String toString() {
        return "ProjectViewAttributes{, projectUuid='" + this.projectUuid + '\'' + ", branchName='" + this.branchName + '\'' + ", analysisDate=" + this.analysisDate + '}';
    }
}

