/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.duplication;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import org.picocontainer.Startable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.duplication.CrossProjectDuplicationStatusHolder;

public class CrossProjectDuplicationStatusHolderImpl
implements CrossProjectDuplicationStatusHolder,
Startable {
    private static final Logger LOGGER = Loggers.get(CrossProjectDuplicationStatusHolderImpl.class);
    @CheckForNull
    private Boolean enabled;
    private final AnalysisMetadataHolder analysisMetadataHolder;

    public CrossProjectDuplicationStatusHolderImpl(AnalysisMetadataHolder analysisMetadataHolder) {
        this.analysisMetadataHolder = analysisMetadataHolder;
    }

    @Override
    public boolean isEnabled() {
        Preconditions.checkState((this.enabled != null ? 1 : 0) != 0, (Object)"Flag hasn't been initialized, the start() should have been called before.");
        return this.enabled;
    }

    public void start() {
        boolean enabledInReport = this.analysisMetadataHolder.isCrossProjectDuplicationEnabled();
        boolean supportedByBranch = this.analysisMetadataHolder.getBranch().supportsCrossProjectCpd();
        if (enabledInReport && supportedByBranch) {
            LOGGER.debug("Cross project duplication is enabled");
            this.enabled = true;
        } else {
            if (!enabledInReport) {
                LOGGER.debug("Cross project duplication is disabled because it's disabled in the analysis report");
            } else {
                LOGGER.debug("Cross project duplication is disabled because of a branch is used");
            }
            this.enabled = false;
        }
    }

    public void stop() {
    }
}

