/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.duplication;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.duplication.Duplication;
import org.sonar.ce.task.projectanalysis.duplication.DuplicationRepository;

public class DuplicationRepositoryImpl
implements DuplicationRepository {
    private Multimap<String, Duplication> duplications = HashMultimap.create();

    @Override
    public Iterable<Duplication> getDuplications(Component file) {
        DuplicationRepositoryImpl.checkFileComponentArgument(file);
        Collection res = (Collection)this.duplications.asMap().get(file.getDbKey());
        if (res == null) {
            return Collections.emptyList();
        }
        return res;
    }

    @Override
    public void add(Component file, Duplication duplication) {
        DuplicationRepositoryImpl.checkFileComponentArgument(file);
        Preconditions.checkNotNull((Object)duplication, (Object)"duplication can not be null");
        this.duplications.put((Object)file.getDbKey(), (Object)duplication);
    }

    private static void checkFileComponentArgument(Component file) {
        Objects.requireNonNull(file, "file can not be null");
        Preconditions.checkArgument((file.getType() == Component.Type.FILE ? 1 : 0) != 0, (Object)"type of file must be FILE");
    }
}

