/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.filemove;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.sonar.ce.task.projectanalysis.filemove.Match;
import org.sonar.ce.task.projectanalysis.filemove.ScoreMatrix;

abstract class MatchesByScore
implements Iterable<List<Match>> {
    MatchesByScore() {
    }

    public static MatchesByScore create(ScoreMatrix scoreMatrix) {
        if (scoreMatrix.getMaxScore() < 85) {
            return EmptyMatchesByScore.INSTANCE;
        }
        MatchesByScoreImpl res = new MatchesByScoreImpl(scoreMatrix);
        res.populate();
        return res;
    }

    public abstract int getSize();

    private static class EmptyMatchesByScore
    extends MatchesByScore {
        private static final EmptyMatchesByScore INSTANCE = new EmptyMatchesByScore();

        private EmptyMatchesByScore() {
        }

        @Override
        public int getSize() {
            return 0;
        }

        @Override
        public Iterator<List<Match>> iterator() {
            return Collections.emptyList().iterator();
        }
    }

    private static final class MatchesByScoreImpl
    extends MatchesByScore
    implements ScoreMatrix.ScoreMatrixVisitor {
        private final ScoreMatrix scoreMatrix;
        private final List<Match>[] matches;
        private int totalMatches = 0;

        private MatchesByScoreImpl(ScoreMatrix scoreMatrix) {
            this.scoreMatrix = scoreMatrix;
            this.matches = new List[scoreMatrix.getMaxScore() - 85 + 1];
        }

        private void populate() {
            this.scoreMatrix.accept(this);
        }

        @Override
        public void visit(ScoreMatrix.ScoreFile removedFile, ScoreMatrix.ScoreFile newFile, int score) {
            if (!MatchesByScoreImpl.isAcceptableScore(score)) {
                return;
            }
            int index = this.scoreMatrix.getMaxScore() - score;
            if (this.matches[index] == null) {
                this.matches[index] = new ArrayList<Match>(1);
            }
            Match match = new Match(removedFile.getFileUuid(), newFile.getFileUuid());
            this.matches[index].add(match);
            ++this.totalMatches;
        }

        private static boolean isAcceptableScore(int score) {
            return score >= 85;
        }

        @Override
        public int getSize() {
            return this.totalMatches;
        }

        @Override
        public Iterator<List<Match>> iterator() {
            return Arrays.asList(this.matches).iterator();
        }
    }
}

