/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.filemove.MovedFilesRepository;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.tracking.Input;
import org.sonar.core.issue.tracking.LazyInput;
import org.sonar.core.issue.tracking.LineHashSequence;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;

public abstract class BaseInputFactory {
    private static final LineHashSequence EMPTY_LINE_HASH_SEQUENCE = new LineHashSequence(Collections.emptyList());

    abstract Input<DefaultIssue> create(Component var1);

    static abstract class BaseLazyInput
    extends LazyInput<DefaultIssue> {
        private final DbClient dbClient;
        final Component component;
        final String effectiveUuid;

        BaseLazyInput(DbClient dbClient, Component component, @Nullable MovedFilesRepository.OriginalFile originalFile) {
            this.dbClient = dbClient;
            this.component = component;
            this.effectiveUuid = originalFile == null ? component.getUuid() : originalFile.getUuid();
        }

        protected LineHashSequence loadLineHashSequence() {
            if (this.component.getType() != Component.Type.FILE) {
                return EMPTY_LINE_HASH_SEQUENCE;
            }
            try (DbSession session = this.dbClient.openSession(false);){
                List hashes = this.dbClient.fileSourceDao().selectLineHashes(session, this.effectiveUuid);
                if (hashes == null || hashes.isEmpty()) {
                    LineHashSequence lineHashSequence = EMPTY_LINE_HASH_SEQUENCE;
                    return lineHashSequence;
                }
                LineHashSequence lineHashSequence = new LineHashSequence(hashes);
                return lineHashSequence;
            }
        }
    }
}

