/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.filemove.MovedFilesRepository;
import org.sonar.ce.task.projectanalysis.issue.BaseInputFactory;
import org.sonar.ce.task.projectanalysis.issue.ComponentIssuesLoader;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.tracking.Input;
import org.sonar.db.DbClient;

public class ClosedIssuesInputFactory
extends BaseInputFactory {
    private final ComponentIssuesLoader issuesLoader;
    private final DbClient dbClient;
    private final MovedFilesRepository movedFilesRepository;

    public ClosedIssuesInputFactory(ComponentIssuesLoader issuesLoader, DbClient dbClient, MovedFilesRepository movedFilesRepository) {
        this.issuesLoader = issuesLoader;
        this.dbClient = dbClient;
        this.movedFilesRepository = movedFilesRepository;
    }

    @Override
    public Input<DefaultIssue> create(Component component) {
        return new ClosedIssuesLazyInput(this.dbClient, component, this.movedFilesRepository.getOriginalFile(component).orElse(null));
    }

    private class ClosedIssuesLazyInput
    extends BaseInputFactory.BaseLazyInput {
        ClosedIssuesLazyInput(DbClient dbClient, @Nullable Component component, MovedFilesRepository.OriginalFile originalFile) {
            super(dbClient, component, originalFile);
        }

        protected List<DefaultIssue> loadIssues() {
            return ClosedIssuesInputFactory.this.issuesLoader.loadClosedIssues(this.effectiveUuid);
        }
    }
}

