/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.issue.MutableComponentIssuesRepository;
import org.sonar.core.issue.DefaultIssue;

public class ComponentIssuesRepositoryImpl
implements MutableComponentIssuesRepository {
    @CheckForNull
    private List<DefaultIssue> issues;
    @CheckForNull
    private Component component;

    @Override
    public void setIssues(Component component, List<DefaultIssue> issues) {
        this.issues = Objects.requireNonNull(issues, "issues cannot be null");
        this.component = Objects.requireNonNull(component, "component cannot be null");
    }

    @Override
    public List<DefaultIssue> getIssues(Component component) {
        if (component.getType() == Component.Type.DIRECTORY) {
            return Collections.emptyList();
        }
        Preconditions.checkState((this.component != null && this.issues != null ? 1 : 0) != 0, (Object)"Issues have not been initialized");
        Preconditions.checkArgument((boolean)component.equals(this.component), (String)"Only issues from component '%s' are available, but wanted component is '%s'.", (Object[])new Object[]{this.component.getReportAttributes().getRef(), component.getReportAttributes().getRef()});
        return this.issues;
    }
}

