/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue;

import java.util.HashMap;
import java.util.Map;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.issue.IssueVisitor;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.measure.MeasureRepository;
import org.sonar.ce.task.projectanalysis.metric.Metric;
import org.sonar.ce.task.projectanalysis.metric.MetricRepository;
import org.sonar.core.issue.DefaultIssue;

public class EffortAggregator
extends IssueVisitor {
    private final MeasureRepository measureRepository;
    private final Map<String, EffortCounter> effortsByComponentUuid = new HashMap<String, EffortCounter>();
    private final Metric maintainabilityEffortMetric;
    private final Metric reliabilityEffortMetric;
    private final Metric securityEffortMetric;
    private EffortCounter effortCounter;

    public EffortAggregator(MetricRepository metricRepository, MeasureRepository measureRepository) {
        this.measureRepository = measureRepository;
        this.maintainabilityEffortMetric = metricRepository.getByKey("sqale_index");
        this.reliabilityEffortMetric = metricRepository.getByKey("reliability_remediation_effort");
        this.securityEffortMetric = metricRepository.getByKey("security_remediation_effort");
    }

    @Override
    public void beforeComponent(Component component) {
        this.effortCounter = new EffortCounter();
        this.effortsByComponentUuid.put(component.getUuid(), this.effortCounter);
        for (Component child : component.getChildren()) {
            EffortCounter childEffortCounter = this.effortsByComponentUuid.remove(child.getUuid());
            if (childEffortCounter == null) continue;
            this.effortCounter.add(childEffortCounter);
        }
    }

    @Override
    public void onIssue(Component component, DefaultIssue issue) {
        if (issue.resolution() == null) {
            this.effortCounter.add(issue);
        }
    }

    @Override
    public void afterComponent(Component component) {
        this.computeMaintainabilityEffortMeasure(component);
        this.computeReliabilityEffortMeasure(component);
        this.computeSecurityEffortMeasure(component);
        this.effortCounter = null;
    }

    private void computeMaintainabilityEffortMeasure(Component component) {
        this.measureRepository.add(component, this.maintainabilityEffortMetric, Measure.newMeasureBuilder().create(this.effortCounter.maintainabilityEffort));
    }

    private void computeReliabilityEffortMeasure(Component component) {
        this.measureRepository.add(component, this.reliabilityEffortMetric, Measure.newMeasureBuilder().create(this.effortCounter.reliabilityEffort));
    }

    private void computeSecurityEffortMeasure(Component component) {
        this.measureRepository.add(component, this.securityEffortMetric, Measure.newMeasureBuilder().create(this.effortCounter.securityEffort));
    }

    private static class EffortCounter {
        private long maintainabilityEffort = 0L;
        private long reliabilityEffort = 0L;
        private long securityEffort = 0L;

        private EffortCounter() {
        }

        void add(DefaultIssue issue) {
            Long issueEffort = issue.effortInMinutes();
            if (issueEffort != null && issueEffort != 0L) {
                switch (issue.type()) {
                    case CODE_SMELL: {
                        this.maintainabilityEffort += issueEffort.longValue();
                        break;
                    }
                    case BUG: {
                        this.reliabilityEffort += issueEffort.longValue();
                        break;
                    }
                    case VULNERABILITY: {
                        this.securityEffort += issueEffort.longValue();
                        break;
                    }
                    case SECURITY_HOTSPOT: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException(String.format("Unknown type '%s'", issue.type()));
                    }
                }
            }
        }

        public void add(EffortCounter effortCounter) {
            this.maintainabilityEffort += effortCounter.maintainabilityEffort;
            this.reliabilityEffort += effortCounter.reliabilityEffort;
            this.securityEffort += effortCounter.securityEffort;
        }
    }
}

