/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue;

import com.google.common.collect.EnumMultiset;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multiset;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.api.rules.RuleType;
import org.sonar.api.utils.DateUtils;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.issue.IssueVisitor;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.measure.MeasureRepository;
import org.sonar.ce.task.projectanalysis.metric.Metric;
import org.sonar.ce.task.projectanalysis.metric.MetricRepository;
import org.sonar.ce.task.projectanalysis.period.Period;
import org.sonar.ce.task.projectanalysis.period.PeriodHolder;
import org.sonar.core.issue.DefaultIssue;

public class IssueCounter
extends IssueVisitor {
    private static final Map<String, String> SEVERITY_TO_METRIC_KEY = ImmutableMap.of((Object)"BLOCKER", (Object)"blocker_violations", (Object)"CRITICAL", (Object)"critical_violations", (Object)"MAJOR", (Object)"major_violations", (Object)"MINOR", (Object)"minor_violations", (Object)"INFO", (Object)"info_violations");
    private static final Map<String, String> SEVERITY_TO_NEW_METRIC_KEY = ImmutableMap.of((Object)"BLOCKER", (Object)"new_blocker_violations", (Object)"CRITICAL", (Object)"new_critical_violations", (Object)"MAJOR", (Object)"new_major_violations", (Object)"MINOR", (Object)"new_minor_violations", (Object)"INFO", (Object)"new_info_violations");
    private static final Map<RuleType, String> TYPE_TO_METRIC_KEY = ImmutableMap.builder().put((Object)RuleType.CODE_SMELL, (Object)"code_smells").put((Object)RuleType.BUG, (Object)"bugs").put((Object)RuleType.VULNERABILITY, (Object)"vulnerabilities").put((Object)RuleType.SECURITY_HOTSPOT, (Object)"security_hotspots").build();
    private static final Map<RuleType, String> TYPE_TO_NEW_METRIC_KEY = ImmutableMap.builder().put((Object)RuleType.CODE_SMELL, (Object)"new_code_smells").put((Object)RuleType.BUG, (Object)"new_bugs").put((Object)RuleType.VULNERABILITY, (Object)"new_vulnerabilities").put((Object)RuleType.SECURITY_HOTSPOT, (Object)"new_security_hotspots").build();
    private final PeriodHolder periodHolder;
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final MetricRepository metricRepository;
    private final MeasureRepository measureRepository;
    private final Map<String, Counters> countersByComponentUuid = new HashMap<String, Counters>();
    private Counters currentCounters;

    public IssueCounter(PeriodHolder periodHolder, AnalysisMetadataHolder analysisMetadataHolder, MetricRepository metricRepository, MeasureRepository measureRepository) {
        this.periodHolder = periodHolder;
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.metricRepository = metricRepository;
        this.measureRepository = measureRepository;
    }

    @Override
    public void beforeComponent(Component component) {
        this.currentCounters = new Counters();
        this.countersByComponentUuid.put(component.getUuid(), this.currentCounters);
        for (Component child : component.getChildren()) {
            Counters childCounters = this.countersByComponentUuid.remove(child.getUuid());
            this.currentCounters.add(childCounters);
        }
    }

    @Override
    public void onIssue(Component component, DefaultIssue issue) {
        this.currentCounters.add(issue);
        if (this.analysisMetadataHolder.isSLBorPR()) {
            this.currentCounters.addOnPeriod(issue);
        } else if (this.periodHolder.hasPeriod()) {
            Period period = this.periodHolder.getPeriod();
            if (issue.creationDate().getTime() > DateUtils.truncateToSeconds((long)period.getSnapshotDate())) {
                this.currentCounters.addOnPeriod(issue);
            }
        }
    }

    @Override
    public void afterComponent(Component component) {
        this.addMeasuresBySeverity(component);
        this.addMeasuresByStatus(component);
        this.addMeasuresByType(component);
        this.addNewMeasures(component);
        this.currentCounters = null;
    }

    private void addMeasuresBySeverity(Component component) {
        for (Map.Entry<String, String> entry : SEVERITY_TO_METRIC_KEY.entrySet()) {
            String severity = entry.getKey();
            String metricKey = entry.getValue();
            this.addMeasure(component, metricKey, this.currentCounters.counter().severityBag.count((Object)severity));
        }
    }

    private void addMeasuresByStatus(Component component) {
        this.addMeasure(component, "violations", this.currentCounters.counter().unresolved);
        this.addMeasure(component, "open_issues", this.currentCounters.counter().open);
        this.addMeasure(component, "reopened_issues", this.currentCounters.counter().reopened);
        this.addMeasure(component, "confirmed_issues", this.currentCounters.counter().confirmed);
        this.addMeasure(component, "false_positive_issues", this.currentCounters.counter().falsePositives);
        this.addMeasure(component, "wont_fix_issues", this.currentCounters.counter().wontFix);
    }

    private void addMeasuresByType(Component component) {
        for (Map.Entry<RuleType, String> entry : TYPE_TO_METRIC_KEY.entrySet()) {
            this.addMeasure(component, entry.getValue(), this.currentCounters.counter().typeBag.count((Object)entry.getKey()));
        }
    }

    private void addMeasure(Component component, String metricKey, int value) {
        Metric metric = this.metricRepository.getByKey(metricKey);
        this.measureRepository.add(component, metric, Measure.newMeasureBuilder().create(value));
    }

    private void addNewMeasures(Component component) {
        Metric metric;
        Multiset bag;
        String metricKey;
        if (!this.periodHolder.hasPeriod() && !this.analysisMetadataHolder.isSLBorPR()) {
            return;
        }
        double unresolvedVariations = this.currentCounters.counterForPeriod().unresolved;
        this.measureRepository.add(component, this.metricRepository.getByKey("new_violations"), Measure.newMeasureBuilder().setVariation(unresolvedVariations).createNoValue());
        for (Map.Entry<String, String> entry : SEVERITY_TO_NEW_METRIC_KEY.entrySet()) {
            String severity = entry.getKey();
            metricKey = entry.getValue();
            bag = this.currentCounters.counterForPeriod().severityBag;
            metric = this.metricRepository.getByKey(metricKey);
            this.measureRepository.add(component, metric, Measure.newMeasureBuilder().setVariation(bag.count((Object)severity)).createNoValue());
        }
        for (Map.Entry<String, String> entry : TYPE_TO_NEW_METRIC_KEY.entrySet()) {
            RuleType type = (RuleType)entry.getKey();
            metricKey = entry.getValue();
            bag = this.currentCounters.counterForPeriod().typeBag;
            metric = this.metricRepository.getByKey(metricKey);
            this.measureRepository.add(component, metric, Measure.newMeasureBuilder().setVariation(bag.count((Object)type)).createNoValue());
        }
    }

    private static class Counters {
        private final Counter counter = new Counter();
        private final Counter counterForPeriod = new Counter();

        private Counters() {
        }

        void add(@Nullable Counters other) {
            if (other != null) {
                this.counter.add(other.counter);
                this.counterForPeriod.add(other.counterForPeriod);
            }
        }

        void addOnPeriod(DefaultIssue issue) {
            this.counterForPeriod.add(issue);
        }

        void add(DefaultIssue issue) {
            this.counter.add(issue);
        }

        Counter counter() {
            return this.counter;
        }

        Counter counterForPeriod() {
            return this.counterForPeriod;
        }
    }

    private static class Counter {
        private int unresolved = 0;
        private int open = 0;
        private int reopened = 0;
        private int confirmed = 0;
        private int falsePositives = 0;
        private int wontFix = 0;
        private final Multiset<String> severityBag = HashMultiset.create();
        private final EnumMultiset<RuleType> typeBag = EnumMultiset.create(RuleType.class);

        private Counter() {
        }

        void add(Counter counter) {
            this.unresolved += counter.unresolved;
            this.open += counter.open;
            this.reopened += counter.reopened;
            this.confirmed += counter.confirmed;
            this.falsePositives += counter.falsePositives;
            this.wontFix += counter.wontFix;
            this.severityBag.addAll(counter.severityBag);
            this.typeBag.addAll(counter.typeBag);
        }

        void add(DefaultIssue issue) {
            if (issue.type() == RuleType.SECURITY_HOTSPOT) {
                if (issue.resolution() == null) {
                    this.typeBag.add((Object)RuleType.SECURITY_HOTSPOT);
                }
                return;
            }
            if (issue.resolution() == null) {
                ++this.unresolved;
                this.typeBag.add((Object)issue.type());
                this.severityBag.add((Object)issue.severity());
            } else if ("FALSE-POSITIVE".equals(issue.resolution())) {
                ++this.falsePositives;
            } else if ("WONTFIX".equals(issue.resolution())) {
                ++this.wontFix;
            }
            switch (issue.status()) {
                case "OPEN": {
                    ++this.open;
                    break;
                }
                case "REOPENED": {
                    ++this.reopened;
                    break;
                }
                case "CONFIRMED": {
                    ++this.confirmed;
                    break;
                }
            }
        }
    }
}

