/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue;

import java.util.Objects;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.db.protobuf.DbCommons;
import org.sonar.db.protobuf.DbIssues;

class IssueLocations {
    private IssueLocations() {
    }

    public static IntStream allLinesFor(DefaultIssue issue, String componentId) {
        DbIssues.Locations locations = (DbIssues.Locations)issue.getLocations();
        if (locations == null) {
            return IntStream.empty();
        }
        Stream<DbCommons.TextRange> textRanges = Stream.concat(locations.hasTextRange() ? Stream.of(locations.getTextRange()) : Stream.empty(), locations.getFlowList().stream().flatMap(f -> f.getLocationList().stream()).filter(l -> Objects.equals(IssueLocations.componentIdOf(issue, l), componentId)).map(DbIssues.Location::getTextRange));
        return textRanges.flatMapToInt(range -> IntStream.rangeClosed(range.getStartLine(), range.getEndLine()));
    }

    private static String componentIdOf(DefaultIssue issue, DbIssues.Location location) {
        if (location.hasComponentId()) {
            return StringUtils.defaultIfEmpty((String)location.getComponentId(), (String)issue.componentUuid());
        }
        return issue.componentUuid();
    }
}

