/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue;

import com.google.common.base.Joiner;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.util.cache.CacheLoader;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.user.index.UserDoc;
import org.sonar.server.user.index.UserIndex;

public class ScmAccountToUserLoader
implements CacheLoader<String, String> {
    private static final Logger LOGGER = Loggers.get(ScmAccountToUserLoader.class);
    private final UserIndex index;
    private final AnalysisMetadataHolder analysisMetadataHolder;

    public ScmAccountToUserLoader(UserIndex index, AnalysisMetadataHolder analysisMetadataHolder) {
        this.index = index;
        this.analysisMetadataHolder = analysisMetadataHolder;
    }

    @Override
    public String load(String scmAccount) {
        List users = this.index.getAtMostThreeActiveUsersForScmAccount(scmAccount, this.analysisMetadataHolder.getOrganization().getUuid());
        if (users.size() == 1) {
            return ((UserDoc)users.get(0)).uuid();
        }
        if (!users.isEmpty()) {
            Collection logins = (Collection)users.stream().map(UserDoc::login).sorted((Comparator<String>)Ordering.natural()).collect(MoreCollectors.toList((int)users.size()));
            LOGGER.warn(String.format("Multiple users share the SCM account '%s': %s", scmAccount, Joiner.on((String)", ").join((Iterable)logins)));
        }
        return null;
    }

    @Override
    public Map<String, String> loadAll(Collection<? extends String> scmAccounts) {
        throw new UnsupportedOperationException("Loading by multiple scm accounts is not supported yet");
    }
}

