/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue;

import java.util.Collection;
import java.util.Map;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.issue.IssueLifecycle;
import org.sonar.ce.task.projectanalysis.issue.SiblingIssue;
import org.sonar.ce.task.projectanalysis.issue.SiblingsIssuesLoader;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.tracking.SimpleTracker;
import org.sonar.core.issue.tracking.Tracking;

public class SiblingsIssueMerger {
    private final SiblingsIssuesLoader siblingsIssuesLoader;
    private final SimpleTracker<DefaultIssue, SiblingIssue> tracker;
    private final IssueLifecycle issueLifecycle;

    public SiblingsIssueMerger(SiblingsIssuesLoader resolvedSiblingsIssuesLoader, IssueLifecycle issueLifecycle) {
        this(resolvedSiblingsIssuesLoader, (SimpleTracker<DefaultIssue, SiblingIssue>)new SimpleTracker(), issueLifecycle);
    }

    public SiblingsIssueMerger(SiblingsIssuesLoader siblingsIssuesLoader, SimpleTracker<DefaultIssue, SiblingIssue> tracker, IssueLifecycle issueLifecycle) {
        this.siblingsIssuesLoader = siblingsIssuesLoader;
        this.tracker = tracker;
        this.issueLifecycle = issueLifecycle;
    }

    public void tryMerge(Component component, Collection<DefaultIssue> newIssues) {
        Collection<SiblingIssue> siblingIssues = this.siblingsIssuesLoader.loadCandidateSiblingIssuesForMerging(component);
        Tracking tracking = this.tracker.track(newIssues, siblingIssues);
        Map matchedRaws = tracking.getMatchedRaws();
        Map<SiblingIssue, DefaultIssue> defaultIssues = this.siblingsIssuesLoader.loadDefaultIssuesWithChanges(matchedRaws.values());
        for (Map.Entry e : matchedRaws.entrySet()) {
            SiblingIssue issue = (SiblingIssue)e.getValue();
            this.issueLifecycle.mergeConfirmedOrResolvedFromShortLivingBranchOrPr((DefaultIssue)e.getKey(), defaultIssues.get(issue), issue.getBranchType(), issue.getBranchKey());
        }
    }
}

