/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue.commonrule;

import java.util.Optional;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.issue.commonrule.CommonRule;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.measure.MeasureRepository;
import org.sonar.ce.task.projectanalysis.metric.Metric;
import org.sonar.ce.task.projectanalysis.metric.MetricRepository;
import org.sonar.ce.task.projectanalysis.qualityprofile.ActiveRule;
import org.sonar.ce.task.projectanalysis.qualityprofile.ActiveRulesHolder;

public class DuplicatedBlockRule
extends CommonRule {
    private final MeasureRepository measureRepository;
    private final Metric duplicatedBlocksMetric;

    public DuplicatedBlockRule(ActiveRulesHolder activeRulesHolder, MeasureRepository measureRepository, MetricRepository metricRepository) {
        super(activeRulesHolder, "DuplicatedBlocks");
        this.measureRepository = measureRepository;
        this.duplicatedBlocksMetric = metricRepository.getByKey("duplicated_blocks");
    }

    @Override
    protected CommonRule.CommonRuleIssue doProcessFile(Component file, ActiveRule activeRule) {
        Optional<Measure> duplicatedBlocksMeasure = this.measureRepository.getRawMeasure(file, this.duplicatedBlocksMetric);
        if (duplicatedBlocksMeasure.isPresent() && duplicatedBlocksMeasure.get().getIntValue() > 0) {
            int duplicatedBlocks = duplicatedBlocksMeasure.get().getIntValue();
            String message = String.format("%d duplicated blocks of code must be removed.", duplicatedBlocks);
            return new CommonRule.CommonRuleIssue(duplicatedBlocks, message);
        }
        return null;
    }
}

