/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.measure;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.metric.Metric;
import org.sonar.db.measure.LiveMeasureDto;

public class LiveMeasureDtoToMeasure {
    public Optional<Measure> toMeasure(@Nullable LiveMeasureDto measureDto, Metric metric) {
        Objects.requireNonNull(metric);
        if (measureDto == null) {
            return Optional.empty();
        }
        Double value = measureDto.getValue();
        String data = measureDto.getDataAsString();
        switch (metric.getType().getValueType()) {
            case INT: {
                return LiveMeasureDtoToMeasure.toIntegerMeasure(measureDto, value, data);
            }
            case LONG: {
                return LiveMeasureDtoToMeasure.toLongMeasure(measureDto, value, data);
            }
            case DOUBLE: {
                return LiveMeasureDtoToMeasure.toDoubleMeasure(measureDto, value, data);
            }
            case BOOLEAN: {
                return LiveMeasureDtoToMeasure.toBooleanMeasure(measureDto, value, data);
            }
            case STRING: {
                return LiveMeasureDtoToMeasure.toStringMeasure(measureDto, data);
            }
            case LEVEL: {
                return LiveMeasureDtoToMeasure.toLevelMeasure(measureDto, data);
            }
            case NO_VALUE: {
                return LiveMeasureDtoToMeasure.toNoValueMeasure(measureDto);
            }
        }
        throw new IllegalArgumentException("Unsupported Measure.ValueType " + (Object)((Object)metric.getType().getValueType()));
    }

    private static Optional<Measure> toIntegerMeasure(LiveMeasureDto measureDto, @Nullable Double value, @Nullable String data) {
        if (value == null) {
            return LiveMeasureDtoToMeasure.toNoValueMeasure(measureDto);
        }
        return Optional.of(LiveMeasureDtoToMeasure.setCommonProperties(Measure.newMeasureBuilder(), measureDto).create(value.intValue(), data));
    }

    private static Optional<Measure> toLongMeasure(LiveMeasureDto measureDto, @Nullable Double value, @Nullable String data) {
        if (value == null) {
            return LiveMeasureDtoToMeasure.toNoValueMeasure(measureDto);
        }
        return Optional.of(LiveMeasureDtoToMeasure.setCommonProperties(Measure.newMeasureBuilder(), measureDto).create(value.longValue(), data));
    }

    private static Optional<Measure> toDoubleMeasure(LiveMeasureDto measureDto, @Nullable Double value, @Nullable String data) {
        if (value == null) {
            return LiveMeasureDtoToMeasure.toNoValueMeasure(measureDto);
        }
        return Optional.of(LiveMeasureDtoToMeasure.setCommonProperties(Measure.newMeasureBuilder(), measureDto).create(value, 5, data));
    }

    private static Optional<Measure> toBooleanMeasure(LiveMeasureDto measureDto, @Nullable Double value, @Nullable String data) {
        if (value == null) {
            return LiveMeasureDtoToMeasure.toNoValueMeasure(measureDto);
        }
        return Optional.of(LiveMeasureDtoToMeasure.setCommonProperties(Measure.newMeasureBuilder(), measureDto).create(value == 1.0, data));
    }

    private static Optional<Measure> toStringMeasure(LiveMeasureDto measureDto, @Nullable String data) {
        if (data == null) {
            return LiveMeasureDtoToMeasure.toNoValueMeasure(measureDto);
        }
        return Optional.of(LiveMeasureDtoToMeasure.setCommonProperties(Measure.newMeasureBuilder(), measureDto).create(data));
    }

    private static Optional<Measure> toLevelMeasure(LiveMeasureDto measureDto, @Nullable String data) {
        if (data == null) {
            return LiveMeasureDtoToMeasure.toNoValueMeasure(measureDto);
        }
        Optional<Measure.Level> level = Measure.Level.toLevel(data);
        if (!level.isPresent()) {
            return LiveMeasureDtoToMeasure.toNoValueMeasure(measureDto);
        }
        return Optional.of(LiveMeasureDtoToMeasure.setCommonProperties(Measure.newMeasureBuilder(), measureDto).create(level.get()));
    }

    private static Optional<Measure> toNoValueMeasure(LiveMeasureDto measureDto) {
        return Optional.of(LiveMeasureDtoToMeasure.setCommonProperties(Measure.newMeasureBuilder(), measureDto).createNoValue());
    }

    private static Measure.NewMeasureBuilder setCommonProperties(Measure.NewMeasureBuilder builder, LiveMeasureDto measureDto) {
        Double variation = measureDto.getVariation();
        if (variation != null) {
            builder.setVariation(variation);
        }
        return builder;
    }
}

