/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.measure;

import java.util.Optional;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.component.TreeRootHolder;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.measure.MeasureRepository;
import org.sonar.ce.task.projectanalysis.measure.PostMeasuresComputationCheck;
import org.sonar.ce.task.projectanalysis.metric.Metric;
import org.sonar.ce.task.projectanalysis.metric.MetricRepository;
import org.sonar.ce.task.step.ComputationStep;

@ComputeEngineSide
public class PostMeasuresComputationChecksStep
implements ComputationStep {
    private final TreeRootHolder treeRootHolder;
    private final MetricRepository metricRepository;
    private final MeasureRepository measureRepository;
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final PostMeasuresComputationCheck[] extensions;

    public PostMeasuresComputationChecksStep(TreeRootHolder treeRootHolder, MetricRepository metricRepository, MeasureRepository measureRepository, AnalysisMetadataHolder analysisMetadataHolder, PostMeasuresComputationCheck[] extensions) {
        this.treeRootHolder = treeRootHolder;
        this.metricRepository = metricRepository;
        this.measureRepository = measureRepository;
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.extensions = extensions;
    }

    public PostMeasuresComputationChecksStep(TreeRootHolder treeRootHolder, MetricRepository metricRepository, MeasureRepository measureRepository, AnalysisMetadataHolder analysisMetadataHolder) {
        this(treeRootHolder, metricRepository, measureRepository, analysisMetadataHolder, new PostMeasuresComputationCheck[0]);
    }

    public void execute(ComputationStep.Context context) {
        ContextImpl extensionContext = new ContextImpl();
        for (PostMeasuresComputationCheck extension : this.extensions) {
            extension.onCheck(extensionContext);
        }
    }

    public String getDescription() {
        return "Checks executed after computation of measures";
    }

    private class ContextImpl
    implements PostMeasuresComputationCheck.Context {
        private ContextImpl() {
        }

        @Override
        public String getProjectUuid() {
            return PostMeasuresComputationChecksStep.this.analysisMetadataHolder.getProject().getUuid();
        }

        @Override
        public int getNcloc() {
            Metric nclocMetric = PostMeasuresComputationChecksStep.this.metricRepository.getByKey("ncloc");
            Optional<Measure> nclocMeasure = PostMeasuresComputationChecksStep.this.measureRepository.getRawMeasure(PostMeasuresComputationChecksStep.this.treeRootHolder.getRoot(), nclocMetric);
            return nclocMeasure.map(Measure::getIntValue).orElse(0);
        }

        @Override
        public String getOrganizationUuid() {
            return PostMeasuresComputationChecksStep.this.analysisMetadataHolder.getOrganization().getUuid();
        }

        @Override
        public String getOrganizationKey() {
            return PostMeasuresComputationChecksStep.this.analysisMetadataHolder.getOrganization().getKey();
        }
    }
}

